// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/label/label.ts >>>

import Foundation

public enum LabelType: Int32, Codable {
  case user = 1
  case system = 3
  case important = 6
  public func toInt() -> Int32 {
    return rawValue
  }
}

@discardableResult
public func int32ToLabelType(_ value: Int32) -> LabelType {
  switch value {
  case 1:
    return LabelType.user
  case 3:
    return LabelType.system
  case 6:
    return LabelType.important
  default:
    return LabelType.system
  }
}

@discardableResult
public func labelTypeToInt32(_ value: LabelType) -> Int32 {
  switch value {
  case LabelType.user:
    return 1
  case LabelType.system:
    return 3
  case LabelType.important:
    return 6
  }
}

open class Label {
  public let lid: LabelID
  public let type: LabelType
  public let name: String!
  public let unreadCounter: Int32
  public let totalCounter: Int32
  public let color: Int32
  public let symbol: Int64
  public init(_ lid: LabelID, _ type: LabelType, _ name: String!, _ unreadCounter: Int32, _ totalCounter: Int32, _ color: Int32, _ symbol: Int64) {
    self.lid = lid
    self.type = type
    self.name = name
    self.unreadCounter = unreadCounter
    self.totalCounter = totalCounter
    self.color = color
    self.symbol = symbol
  }
}

@discardableResult
public func labelFromJSONItem(_ item: JSONItem) -> Label! {
  if item.kind != JSONItemKind.map {
    return nil
  }
  let map = item as! MapJSONItem
  let lid = map.getString("lid")!
  let name: String! = map.getString("display_name")
  let unread = map.getInt32("count_unread")!
  let total = map.getInt32("count_all")!
  let type = int32ToLabelType(map.getInt32("type")!)
  let colorString = map.getString("color")!
  var color: Int32! = stringToInt32(colorString, 16)
  if color == nil {
    color = 0
  }
  return Label(lid, type, name, unread, total, color!, int64(0))
}
