// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/message/messages-response.ts >>>

import Foundation

open class MessageResponse {
  public let status: NetworkStatus
  public let payload: YSArray<MessageResponsePayload>!
  public init(_ status: NetworkStatus, _ payload: YSArray<MessageResponsePayload>!) {
    self.status = status
    self.payload = payload
  }
}

open class MessageResponsePayload {
  public let header: MessagesResponseHeader
  public let items: YSArray<MessageMeta>
  public init(_ header: MessagesResponseHeader, _ items: YSArray<MessageMeta>) {
    self.header = header
    self.items = items
  }
}

@discardableResult
public func messageResponseFromJSONItem(_ item: JSONItem) -> MessageResponse! {
  if item.kind == JSONItemKind.array {
    let array = item as! ArrayJSONItem
    return MessageResponse(NetworkStatus(NetworkStatusCode.ok), messageResponsePayloadFromJSONItems(array))
  } else if item.kind == JSONItemKind.map {
    let map = item as! MapJSONItem
    if map.hasKey("status") {
      return MessageResponse(networkStatusFromJSONItem(map.get("status")!)!, nil)
    }
  }
  return nil
}

@discardableResult
private func messageResponsePayloadFromJSONItems(_ items: ArrayJSONItem) -> YSArray<MessageResponsePayload> {
  return items.asArray().filter {
    item in
    item.kind == JSONItemKind.map
  }.map {
    item in
    let map = item as! MapJSONItem
    let header: MessagesResponseHeader! = messageResponseHeaderFromJSONItem(map.get("header")!)
    let messages: JSONItem! = undefinedToNull(nullthrows(map.getMap("messageBatch")).get("messages"))
    return MessageResponsePayload(header != nil ? header : MessagesResponseHeader.withError(-1), messages != nil ? messageMetasFromJSONItem(messages as! ArrayJSONItem) : YSArray())
  }
}

@discardableResult
private func messageMetasFromJSONItem(_ items: ArrayJSONItem) -> YSArray<MessageMeta> {
  let result: YSArray<MessageMeta> = YSArray()
  for item in items.asArray() {
    let message: MessageMeta! = messageMetaFromJSONItem(item as! MapJSONItem)
    if message != nil {
      result.push(message)
    }
  }
  return result
}
