// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/network/network-request.ts >>>

import Foundation

public typealias NetworkParams = MapJSONItem

public typealias NetworkUrlExtra = MapJSONItem

public enum NetworkAPIVersions: String, Codable {
  case v1
  case v2
  case v3
  case unspecified = ""
  public func toString() -> String {
    return rawValue
  }
}

public enum NetworkMethod: String, Codable {
  case get
  case post
  public func toString() -> String {
    return rawValue
  }
}

public enum RequestEncodingKind {
  case url
  case json
}

public protocol RequestEncoding {
  var kind: RequestEncodingKind { get }
}

open class UrlRequestEncoding: RequestEncoding {
  public let kind: RequestEncodingKind = RequestEncodingKind.url
}

open class JsonRequestEncoding: RequestEncoding {
  public let kind: RequestEncodingKind = RequestEncodingKind.json
}

public protocol NetworkRequest {
  @discardableResult
  func version() -> NetworkAPIVersions
  @discardableResult
  func method() -> NetworkMethod
  @discardableResult
  func path() -> String
  @discardableResult
  func params() -> NetworkParams
  @discardableResult
  func urlExtra() -> NetworkUrlExtra
  @discardableResult
  func encoding() -> RequestEncoding
}

open class BaseNetworkRequest: NetworkRequest {
  public let platform: Platform
  public let networkExtra: NetworkExtra
  public init(_ platform: Platform, _ networkExtra: NetworkExtra) {
    self.platform = platform
    self.networkExtra = networkExtra
  }

  @discardableResult
  open func version() -> NetworkAPIVersions {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func method() -> NetworkMethod {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func path() -> String {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func params() -> NetworkParams {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func urlExtra() -> NetworkUrlExtra {
    let result = MapJSONItem()
    result.putString("client", platformToClient(platform)).putString("app_state", networkExtra.foreground ? "foreground" : "background").putString("uuid", networkExtra.uuid)
    return result
  }

  @discardableResult
  open func encoding() -> RequestEncoding {
    fatalError("Must be overridden in subclasses")
  }
}
