// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/requests/archive-request.ts >>>

import Foundation

open class ArchiveRequest: BaseNetworkRequest {
  private let local: String
  private let mid: ID!
  private let tid: ID!
  public init(_ local: String, _ mid: ID!, _ tid: ID!, _ platform: Platform, _ networkExtra: NetworkExtra) {
    self.local = local
    self.mid = mid
    self.tid = tid
    super.init(platform, networkExtra)
  }

  @discardableResult
  open override func encoding() -> RequestEncoding {
    return UrlRequestEncoding()
  }

  @discardableResult
  open override func method() -> NetworkMethod {
    return NetworkMethod.post
  }

  @discardableResult
  open override func params() -> MapJSONItem {
    let params = MapJSONItem()
    params.put("local", StringJSONItem(local))
    if mid != nil {
      params.put("mids", StringJSONItem(int64ToString(mid)))
    }
    if tid != nil {
      params.put("tids", StringJSONItem(int64ToString(tid)))
    }
    return params
  }

  @discardableResult
  open override func path() -> String {
    return "archive"
  }

  @discardableResult
  open override func version() -> NetworkAPIVersions {
    return NetworkAPIVersions.v1
  }
}
