// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/requests/folder-request.ts >>>

import Foundation

open class FolderRequest: BaseNetworkRequest {
  public override init(_ platform: Platform, _ networkExtra: NetworkExtra) {
    super.init(platform, networkExtra)
  }

  @discardableResult
  open override func version() -> NetworkAPIVersions {
    return NetworkAPIVersions.v1
  }

  @discardableResult
  open override func method() -> NetworkMethod {
    return NetworkMethod.post
  }

  @discardableResult
  open override func encoding() -> RequestEncoding {
    return JsonRequestEncoding()
  }
}

open class MoveToFolderRequest: FolderRequest {
  public let mid: ID!
  public let tid: ID!
  public let fid: ID
  public init(_ mid: ID!, _ tid: ID!, _ fid: ID, _ platform: Platform, _ networkExtra: NetworkExtra) {
    self.mid = mid
    self.tid = tid
    self.fid = fid
    super.init(platform, networkExtra)
  }

  @discardableResult
  open override func params() -> MapJSONItem {
    let params = MapJSONItem()
    if mid != nil {
      params.put("mids", StringJSONItem(int64ToString(mid)))
    }
    if tid != nil {
      params.put("tids", StringJSONItem(int64ToString(tid)))
    }
    params.put("fid", StringJSONItem(int64ToString(fid)))
    return params
  }

  @discardableResult
  open override func path() -> String {
    return "move_to_folder"
  }
}

open class CreateFolderRequest: FolderRequest {
  public let name: String
  public let parentFid: ID!
  public let symbol: String!
  public init(_ name: String, _ parentFid: ID!, _ symbol: String!, _ platform: Platform, _ networkExtra: NetworkExtra) {
    self.name = name
    self.parentFid = parentFid
    self.symbol = symbol
    super.init(platform, networkExtra)
  }

  @discardableResult
  open override func params() -> MapJSONItem {
    let params = MapJSONItem()
    if parentFid != nil {
      params.put("parent_fid", StringJSONItem(int64ToString(parentFid)))
    }
    if symbol != nil {
      params.put("symbol", StringJSONItem(symbol))
    }
    params.put("name", StringJSONItem(name))
    return params
  }

  @discardableResult
  open override func path() -> String {
    return "create_folder"
  }
}
