// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/requests/label-request.ts >>>

import Foundation

open class LabelRequest: BaseNetworkRequest {
  public let mark: Bool
  public let mid: ID!
  public let tid: ID!
  public let lid: LabelID
  public init(_ mark: Bool, _ mid: ID!, _ tid: ID!, _ lid: LabelID, _ platform: Platform, _ networkExtra: NetworkExtra) {
    self.mark = mark
    self.mid = mid
    self.tid = tid
    self.lid = lid
    super.init(platform, networkExtra)
  }

  @discardableResult
  open override func version() -> NetworkAPIVersions {
    return NetworkAPIVersions.v1
  }

  @discardableResult
  open override func method() -> NetworkMethod {
    return NetworkMethod.post
  }

  @discardableResult
  open override func path() -> String {
    return "mark_with_label"
  }

  @discardableResult
  open override func params() -> NetworkParams {
    let params = MapJSONItem()
    if mid != nil {
      params.put("mids", StringJSONItem(int64ToString(mid)))
    }
    if tid != nil {
      params.put("tids", StringJSONItem(int64ToString(tid)))
    }
    params.put("lid", StringJSONItem(lid))
    params.put("mark", StringJSONItem(int32ToString(mark ? 1 : 0)))
    return params
  }

  @discardableResult
  open override func encoding() -> RequestEncoding {
    return JsonRequestEncoding()
  }
}

open class LabelMarkRequest: LabelRequest {
  public init(_ mid: ID!, _ tid: ID!, _ lid: LabelID, _ platform: Platform, _ networkExtra: NetworkExtra) {
    super.init(true, mid, tid, lid, platform, networkExtra)
  }
}

open class LabelUnmarkRequest: LabelRequest {
  public init(_ mid: ID!, _ tid: ID!, _ lid: LabelID, _ platform: Platform, _ networkExtra: NetworkExtra) {
    super.init(false, mid, tid, lid, platform, networkExtra)
  }
}
