// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/requests/mark-request.ts >>>

import Foundation

open class MarkRequest: BaseNetworkRequest {
  private let action: String
  public let mid: ID!
  public let tid: ID!
  public init(_ action: String, _ mid: ID!, _ tid: ID!, _ platform: Platform, _ networkExtra: NetworkExtra) {
    self.action = action
    self.mid = mid
    self.tid = tid
    super.init(platform, networkExtra)
  }

  @discardableResult
  open override func version() -> NetworkAPIVersions {
    return NetworkAPIVersions.v1
  }

  @discardableResult
  open override func method() -> NetworkMethod {
    return NetworkMethod.post
  }

  @discardableResult
  open override func path() -> String {
    return action
  }

  @discardableResult
  open override func params() -> NetworkParams {
    let params = MapJSONItem()
    if mid != nil {
      params.put("mids", StringJSONItem(int64ToString(mid)))
    }
    if tid != nil {
      params.put("tids", StringJSONItem(int64ToString(tid)))
    }
    return params
  }

  @discardableResult
  open override func encoding() -> RequestEncoding {
    return JsonRequestEncoding()
  }
}

open class MarkReadRequest: MarkRequest {
  public init(_ mid: ID!, _ tid: ID!, _ platform: Platform, _ networkExtra: NetworkExtra) {
    super.init("mark_read", mid, tid, platform, networkExtra)
  }
}

open class MarkUnreadRequest: MarkRequest {
  public init(_ mid: ID!, _ tid: ID!, _ platform: Platform, _ networkExtra: NetworkExtra) {
    super.init("mark_unread", mid, tid, platform, networkExtra)
  }
}
