// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/requests/send-request.ts >>>

import Foundation

open class SendRequest: BaseNetworkRequest {
  public let networkParams: NetworkParams
  public init(_ networkParams: NetworkParams, _ platform: Platform, _ networkExtra: NetworkExtra) {
    self.networkParams = networkParams
    super.init(platform, networkExtra)
  }

  @discardableResult
  open override func version() -> NetworkAPIVersions {
    return NetworkAPIVersions.v1
  }

  @discardableResult
  open override func method() -> NetworkMethod {
    return NetworkMethod.post
  }

  @discardableResult
  open override func path() -> String {
    return "send"
  }

  @discardableResult
  open override func params() -> NetworkParams {
    return networkParams
  }

  @discardableResult
  open override func encoding() -> RequestEncoding {
    return JsonRequestEncoding()
  }
}

open class SendRequestBuilder {
  private var params: NetworkParams = MapJSONItem()
  private var platform: Platform
  private var extra: NetworkExtra
  public init(_ platform: Platform, _ extra: NetworkExtra) {
    self.platform = platform
    self.extra = extra
  }

  @discardableResult
  open func subject(_ value: String) -> SendRequestBuilder {
    return addStringParam("subj", value)
  }

  @discardableResult
  open func to(_ value: String) -> SendRequestBuilder {
    return addStringParam("to", value)
  }

  @discardableResult
  open func composeCheck(_ value: String) -> SendRequestBuilder {
    return addStringParam("compose_check", value)
  }

  @discardableResult
  open func send(_ value: String) -> SendRequestBuilder {
    return addStringParam("send", value)
  }

  @discardableResult
  open func inReplyTo(_ value: String) -> SendRequestBuilder {
    return addStringParam("inreplyto", value)
  }

  @discardableResult
  open func references(_ value: String) -> SendRequestBuilder {
    return addStringParam("references", value)
  }

  @discardableResult
  private func addStringParam(_ name: String, _ value: String) -> SendRequestBuilder {
    params.put(name, StringJSONItem(value))
    return self
  }

  @discardableResult
  open func build() -> SendRequest {
    return SendRequest(params, platform, extra)
  }
}
