// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/status/network-status.ts >>>

import Foundation

public enum NetworkStatusCode: Int32, Codable {
  case ok = 1
  case temporaryError = 2
  case permanentError = 3
  public func toInt() -> Int32 {
    return rawValue
  }
}

@discardableResult
private func networkStatusCodeFromInt32(_ value: Int32) -> NetworkStatusCode {
  switch value {
  case 1:
    return NetworkStatusCode.ok
  case 2:
    return NetworkStatusCode.temporaryError
  case 3:
    return NetworkStatusCode.permanentError
  default:
    return NetworkStatusCode.temporaryError
  }
}

open class NetworkStatus {
  public let code: NetworkStatusCode
  public let trace: String!
  public let phrase: String!
  public init(_ code: NetworkStatusCode, _ trace: String! = nil, _ phrase: String! = nil) {
    self.code = code
    self.trace = trace
    self.phrase = phrase
  }
}

@discardableResult
public func networkStatusFromJSONItem(_ item: JSONItem) -> NetworkStatus! {
  if item.kind != JSONItemKind.map {
    return nil
  }
  let map = item as! MapJSONItem
  let statusCode = networkStatusCodeFromInt32(map.getInt32("status")!)
  let trace: String! = map.getString("trace")
  let phrase: String! = map.getString("phrase")
  return NetworkStatus(statusCode, trace, phrase)
}
