// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM event-logs/action-parser.ts >>>

import Foundation

open class ActionParser {
  @discardableResult
  open func parseActionFromJson(_ json: MapJSONItem) -> MBTAction {
    switch json.getString("event_name") {
    case EventNames.LIST_MESSAGE_OPEN:
      return OpenMessage(json.getInt32("order")!)
    case EventNames.LIST_MESSAGE_DELETE:
      return DeleteMessageAction(json.getInt32("order")!)
    case EventNames.LIST_MESSAGE_REFRESH:
      return RefreshMessageListAction()
    case EventNames.MESSAGE_VIEW_BACK:
      return BackToMaillist()
    case EventNames.MESSAGE_VIEW_DELETE:
      return DeleteCurrentMessage()
    default:
      fatalError("Unknown action \(json.getString("event_name"))")
    }
  }

  @discardableResult
  open func parseActionFromString(_ extrasString: String) -> MBTAction {
    return parseActionFromJson(parse(extrasString))
  }

  @discardableResult
  open func parse(_: String) -> MapJSONItem {
    return MapJSONItem()
  }
}
