// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM event-logs/cross-platform-logs-parser.ts >>>

import Foundation

open class CrossPlatformLogsParser {
  private var jsonSerializer: JSONSerializer
  public init(_ jsonSerializer: JSONSerializer) {
    self.jsonSerializer = jsonSerializer
  }

  @discardableResult
  open func parse(_ line: String) -> TestopithecusEvent {
    let json = jsonSerializer.deserialize(line) {
      j in
      Result(j, nil)
    }.getValue() as! MapJSONItem
    let value = requireNonNull(json.getMap("value"), "Нет аттрибутов у эвента!")
    let testopithecusName = (requireNonNull(value.get("event_name"), "Имя евента должно быть в аттрибутах") as! StringJSONItem).value
    let loggingName = requireNonNull(json.getString("name"), "Имя эвента должно быть в имени эвента")
    if loggingName != "TESTOPITHECUS_EVENT_\(testopithecusName)" {
      fatalError("Плохое имя")
    }
    return TestopithecusEvent(testopithecusName, ValueMapBuilder.__parse(value))
  }
}
