// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/mail-features.ts >>>

import Foundation

open class MessageListDisplayFeature: Feature<MessageListDisplay> {
  public static var get: MessageListDisplayFeature = MessageListDisplayFeature()
  private init() {
    super.init("MessageListDisplay")
  }
}

public protocol MessageListDisplay {
  @discardableResult
  func getMessageList(_ limit: Int32) -> YSArray<MessageView>
  func refreshMessageList() -> Void
  @discardableResult
  func unreadCounter() -> Int32
  func goToAccountSwitcher() -> Void
}

public protocol AccountSettingsNavigator {
  func openAccountSettings(_ accountIndex: Int32) -> Void
  func closeAccountSettings() -> Void
}

open class AccountSettingsNavigatorFeature: Feature<AccountSettingsNavigator> {
  public static var get: AccountSettingsNavigatorFeature = AccountSettingsNavigatorFeature()
  public init() {
    super.init("AccountSettingsNavigator")
  }
}

open class GroupBySubjectFeature: Feature<GroupBySubject> {
  public static var get: GroupBySubjectFeature = GroupBySubjectFeature()
  private init() {
    super.init("GroupBySubject")
  }
}

public protocol GroupBySubject {
  @discardableResult
  func getThreadingSetting() -> Bool
  func toggleThreadingSetting() -> Void
}

open class FolderNavigatorFeature: Feature<FolderNavigator> {
  public static var get: FolderNavigatorFeature = FolderNavigatorFeature()
  private init() {
    super.init("FolderNavigator")
  }
}

public protocol FolderNavigator {
  @discardableResult
  func getFoldersList() -> YSArray<Folder>
  func goToFolder(_ folderDisplayName: String) -> Void
  @discardableResult
  func getCurrentFolder() -> Folder
}

open class CreatableFolderFeature: Feature<CreatableFolder> {
  public static var get: CreatableFolderFeature = CreatableFolderFeature()
  private init() {
    super.init("CreatableFolder")
  }
}

public protocol CreatableFolder {
  func createFolder(_ folderDisplayName: String) -> Void
}

open class MovableToFolderFeature: Feature<MovableToFolder> {
  public static var get: MovableToFolderFeature = MovableToFolderFeature()
  private init() {
    super.init("MovableToFolder")
  }
}

public protocol MovableToFolder {
  func moveMessageToFolder(_ order: Int32, _ folderName: String) -> Void
}

open class MarkableReadFeature: Feature<MarkableRead> {
  public static var get: MarkableReadFeature = MarkableReadFeature()
  private init() {
    super.init("MarkableRead", "Дефолтная фича удаления сообщения." + "В мобильных реализуется через full swipe, в Лизе через тулбар")
  }
}

public protocol MarkableRead {
  func markAsRead(_ order: Int32) -> Void
  func markAsUnread(_ order: Int32) -> Void
}

open class ArchiveMessageFeature: Feature<ArchiveMessage> {
  public static var get: ArchiveMessageFeature = ArchiveMessageFeature()
  private init() {
    super.init("ArchiveMessage")
  }
}

public protocol ArchiveMessage {
  func archiveMessage(_ order: Int32) -> Void
  @discardableResult
  func toastShown() -> Bool
}

open class MarkableImportantFeature: Feature<MarkableImportant> {
  public static var get: MarkableImportantFeature = MarkableImportantFeature()
  private init() {
    super.init("MarkableImportant")
  }
}

public protocol MarkableImportant {
  func markAsImportant(_ order: Int32) -> Void
  func markAsUnimportant(_ order: Int32) -> Void
}

open class MessageNavigatorFeature: Feature<MessageNavigator> {
  public static var get: MessageNavigatorFeature = MessageNavigatorFeature()
  private init() {
    super.init("MessageNavigator")
  }
}

public protocol MessageNavigator {
  func openMessage(_ order: Int32) -> Void
  func closeMessage() -> Void
  func deleteCurrentMessage() -> Void
  @discardableResult
  func getOpenedMessage() -> FullMessageView
}

open class GroupModeFeature: Feature<GroupMode> {
  public static var get: GroupModeFeature = GroupModeFeature()
  private init() {
    super.init("GroupMode", "Действия с письмами в режиме групповых операций." + "InitialSelectMessage переводит в компонент GroupMode и производится по лонг тапу." + "SelectMessage выделяет письма, если мы уже в режиме групповых операций по обычному тапу")
  }
}

public protocol GroupMode {
  @discardableResult
  func isInGroupMode() -> Bool
  func selectMessage(_ byOrder: Int32) -> Void
  func initialMessageSelect(_ byOrder: Int32) -> Void
  @discardableResult
  func getSelectedMessages() -> YSSet<Int32>
  func markAsReadSelectedMessages() -> Void
  func markAsUnreadSelectedMessages() -> Void
  func deleteSelectedMessages() -> Void
  func markAsImportantSelectedMessages() -> Void
  func markAsUnImportantSelectedMessages() -> Void
  func markAsSpamSelectedMessages() -> Void
  func markAsNotSpamSelectedMessages() -> Void
  func moveToFolderSelectedMessages(_ folderName: FolderName) -> Void
  func archiveSelectedMessages() -> Void
  func unselectMessage(_ byOrder: Int32) -> Void
  func unselectAllMessages() -> Void
}

open class SettingsFeature: Feature<Settings> {
  public static var get: SettingsFeature = SettingsFeature()
  private init() {
    super.init("Settings")
  }
}

public protocol Settings {
  func clearCache() -> Void
}

open class SettingsNavigatorFeature: Feature<SettingsNavigator> {
  public static var get: SettingsNavigatorFeature = SettingsNavigatorFeature()
  private init() {
    super.init("SettingsNavigator")
  }
}

public protocol SettingsNavigator {
  func openSettings() -> Void
}

open class RotatableFeature: Feature<Rotatable> {
  public static var get: RotatableFeature = RotatableFeature()
  private init() {
    super.init("Rotatable")
  }
}

public protocol Rotatable {
  @discardableResult
  func isInLandscape() -> Bool
  func rotateToLandscape() -> Void
  func rotateToPortrait() -> Void
}

open class ExpandableThreadsModelFeature: Feature<ReadOnlyExpandableThreads> {
  public static var get: ExpandableThreadsModelFeature = ExpandableThreadsModelFeature()
  private init() {
    super.init("ReadOnlyExpandableThreads")
  }
}

public protocol ReadOnlyExpandableThreads {
  @discardableResult
  func isExpanded(_ threadOrder: Int32) -> Bool
  @discardableResult
  func isRead(_ threadOrder: Int32, _ messageOrder: Int32) -> Bool
  @discardableResult
  func getMessagesInThread(_ threadOrder: Int32) -> YSArray<MessageView>
}

open class ExpandableThreadsFeature: Feature<ExpandableThreads> {
  public static var get: ExpandableThreadsFeature = ExpandableThreadsFeature()
  private init() {
    super.init("ExpandableThreads")
  }
}

public protocol ExpandableThreads {
  func markThreadMessageAsRead(_ threadOrder: Int32, _ messageOrder: Int32) -> Void
  func markThreadMessageAsUnRead(_ threadOrder: Int32, _ messageOrder: Int32) -> Void
  func expandThread(_ order: Int32) -> Void
  func collapseThread(_ order: Int32) -> Void
}

open class DeleteMessageFeature: Feature<DeleteMessage> {
  public static var get: DeleteMessageFeature = DeleteMessageFeature()
  private init() {
    super.init("DeleteMessage", "Дефолтная фича удаления сообщения." + "В мобильных реализуется через full swipe, в Лизе через тулбар")
  }
}

public protocol DeleteMessage {
  func deleteMessage(_ order: Int32) -> Void
}

open class ContextMenuFeature: Feature<ContextMenu> {
  public static var get: ContextMenuFeature = ContextMenuFeature()
  private init() {
    super.init("ContextMenu")
  }
}

public protocol ContextMenu {
  func deleteMessageFromContextMenu(_ order: Int32) -> Void
  func markAsReadFromContextMenu(_ order: Int32) -> Void
  func markAsUnreadFromContextMenu(_ order: Int32) -> Void
  func markAsImportantFromContextMenu(_ order: Int32) -> Void
  func markAsUnImportantFromContextMenu(_ order: Int32) -> Void
  func moveToFolderFromContextMenu(_ order: Int32, _ folderName: String) -> Void
}

open class ShortSwipeDeleteFeature: Feature<ShortSwipeDelete> {
  public static var get: ShortSwipeDeleteFeature = ShortSwipeDeleteFeature()
  private init() {
    super.init("ShortSwipeDelete")
  }
}

public protocol ShortSwipeDelete {
  func deleteMessageByShortSwipe(_ order: Int32) -> Void
  @discardableResult
  func toastShown() -> Bool
}

open class WriteMessageFeature: Feature<WriteMessage> {
  public static var get: WriteMessageFeature = WriteMessageFeature()
  private init() {
    super.init("WriteMessage")
  }
}

public protocol WriteMessage {
  func openCompose() -> Void
  func sendMessage(_ to: String, _ subject: String) -> Void
  func replyMessage() -> Void
  func sendPrepared() -> Void
}

open class ComposeMessageFeature: Feature<ComposeMessage> {
  public static var get: ComposeMessageFeature = ComposeMessageFeature()
  private init() {
    super.init("SendMessage")
  }
}

public protocol ComposeMessage {
  func goToMessageReply() -> Void
  func addTo(_ to: String) -> Void
  func addToUsingSuggest(_ to: String) -> Void
  func removeTo(_ order: Int32) -> Void
  func setSubject(_ subject: String) -> Void
  func clearSubject() -> Void
  func setBody(_ body: String) -> Void
  func clearBody() -> Void
  @discardableResult
  func getTo() -> YSSet<String>
  @discardableResult
  func getDraft() -> DraftView
}

open class WysiwygFeature: Feature<WYSIWIG> {
  public static var get: WysiwygFeature = WysiwygFeature()
  private init() {
    super.init("WYSIWYG")
  }
}

public protocol WYSIWIG {
  func setStrong(_ from: Int32, _ to: Int32) -> Void
  func setItalic(_ from: Int32, _ to: Int32) -> Void
  func clearFormatting(_ from: Int32, _ to: Int32) -> Void
  func appendText(_ index: Int32, _ text: String) -> Void
}

open class SpamableFeature: Feature<Spamable> {
  public static var get: SpamableFeature = SpamableFeature()
  private init() {
    super.init("Spamable")
  }
}

public protocol Spamable {
  func moveToSpam(_ order: Int32) -> Void
  func moveFromSpam(_ order: Int32) -> Void
  @discardableResult
  func toastShown() -> Bool
}

open class MultiAccountFeature: Feature<MultiAccount> {
  public static var get: MultiAccountFeature = MultiAccountFeature()
  private init() {
    super.init("MultiAccount")
  }
}

public typealias Login = String

public protocol MultiAccount {
  func switchToAccount(_ login: String) -> Void
  func addNewAccount() -> Void
  @discardableResult
  func getLoggedInAccountsList() -> YSArray<Login>
}

open class YandexLoginFeature: Feature<YandexLogin> {
  public static var get: YandexLoginFeature = YandexLoginFeature()
  private init() {
    super.init("YandexLogin")
  }
}

public protocol YandexLogin {
  func loginWithYandexAccount(_ account: UserAccount) -> Void
}

open class MailRuLoginFeature: Feature<MailRuLogin> {
  public static var get: MailRuLoginFeature = MailRuLoginFeature()
  private init() {
    super.init("MailRuLogin")
  }
}

public protocol MailRuLogin {
  func loginWithMailRuAccount(_ account: UserAccount) -> Void
}

open class GoogleLoginFeature: Feature<GoogleLogin> {
  public static var get: GoogleLoginFeature = GoogleLoginFeature()
  private init() {
    super.init("GoogleLogin")
  }
}

public protocol GoogleLogin {
  func loginWithGoogleAccount(_ account: UserAccount) -> Void
}

open class OutlookLoginFeature: Feature<OutlookLogin> {
  public static var get: OutlookLoginFeature = OutlookLoginFeature()
  private init() {
    super.init("OutlookLogin")
  }
}

public protocol OutlookLogin {
  func loginWithOutlookAccount(_ account: UserAccount) -> Void
}

open class HotmailLoginFeature: Feature<HotmailLogin> {
  public static var get: HotmailLoginFeature = HotmailLoginFeature()
  private init() {
    super.init("HotmailLogin")
  }
}

public protocol HotmailLogin {
  func loginWithHotmailAccount(_ account: UserAccount) -> Void
}

open class RamblerLoginFeature: Feature<RamblerLogin> {
  public static var get: RamblerLoginFeature = RamblerLoginFeature()
  private init() {
    super.init("RamblerLogin")
  }
}

public protocol RamblerLogin {
  func loginWithRamblerAccount(_ account: UserAccount) -> Void
}

open class YahooLoginFeature: Feature<YahooLogin> {
  public static var get: YahooLoginFeature = YahooLoginFeature()
  private init() {
    super.init("YahooLogin")
  }
}

public protocol YahooLogin {
  func loginWithYahooAccount(_ account: UserAccount) -> Void
}

open class CustomMailServiceLoginFeature: Feature<CustomMailServiceLogin> {
  public static var get: CustomMailServiceLoginFeature = CustomMailServiceLoginFeature()
  private init() {
    super.init("CustomMailService")
  }
}

public protocol CustomMailServiceLogin {
  func loginWithCustomMailServiceAccount(_ account: UserAccount) -> Void
}

public protocol MessageView {
  var from: String { get }
  var subject: String { get }
  var read: Bool { get }
  var important: Bool { get }
  var threadCounter: Int32! { get }
  @discardableResult
  func tostring() -> String
}

public protocol FullMessageView {
  var head: MessageView { get }
  var to: YSSet<String> { get }
  var body: String { get }
  @discardableResult
  func tostring() -> String
}

public protocol DraftView {
  var to: YSSet<String> { get set }
  var subject: String! { get set }
  @discardableResult
  func getWysiwyg() -> WysiwygView
  @discardableResult
  func tostring() -> String
}

public protocol WysiwygView {
  @discardableResult
  func getText() -> String
  @discardableResult
  func getStyles(_ i: Int32) -> YSSet<String>
  @discardableResult
  func getRichBody() -> String
}
