// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/mailbox-downloader.ts >>>

import Foundation

open class MailboxDownloader: AppModelProvider {
  private var clients: YSArray<MailboxClient>
  private var logger: Logger
  public init(_ clients: YSArray<MailboxClient>, _ logger: Logger) {
    self.clients = clients
    self.logger = logger
  }

  @discardableResult
  open func takeAppModel() -> AppModel {
    logger.log("Downloading mailbox started")
    let accountsData: YSArray<AccountMailboxData> = YSArray()
    for client in clients {
      logger.log("Downloading account (\(client.userAccount.login)) started")
      let folderList = client.getFolderList().filter {
        folder in
        folder.name != DefaultFolderName.outgoing
      }
      let fidToFolder = YSMap<FolderId, FolderDTO>()
      folderList.forEach {
        folder in
        fidToFolder.set(folder.fid, folder)
      }
      let messages = YSMap<MessageId, FullMessage>()
      let messageToFolder = YSMap<MessageId, Folder>()
      let threads = YSMap<ID, YSSet<MessageId>>()
      let aliases = client.getSettings().payload!.accountInformation.emails.map {
        email in
        display(email)
      }
      let contacts = client.getAllContactsList(1000).map {
        contact in
        emailStringFromContact(contact)
      }
      let accountSettings = AccountSettings(client.getSettings().payload!.settingsSetup.folderThreadView)
      for folder in folderList {
        let messagesDTO = isFolderOfThreadedType(folder.type) ? client.getThreadsInFolder(folder.fid, 10) : client.getMessagesInFolder(folder.fid, 10)
        messagesDTO.forEach {
          messageDTO in
          let messageModel = FullMessage.fromMeta(messageDTO)
          let tid: Int64! = messageDTO.tid
          let threadSize: Int32! = messageModel.head.threadCounter
          if tid != nil, threadSize != nil {
            for threadMessageDTO in client.getMessagesInThread(tid, threadSize) {
              let mid = threadMessageDTO.mid
              if !threads.has(tid) {
                threads.set(tid, YSSet())
              }
              threads.get(tid)!.add(mid)
              messages.set(mid, FullMessage.fromMeta(threadMessageDTO))
              messageToFolder.set(mid, Folder.fromDTO(fidToFolder.get(threadMessageDTO.fid)!))
            }
          } else {
            let mid = messageDTO.mid
            messages.set(mid, messageModel)
            messageToFolder.set(mid, Folder.fromDTO(fidToFolder.get(messageDTO.fid)!))
          }
        }
      }
      let folderToMessages: YSMap<FolderName, YSSet<MessageId>> = YSMap<FolderName, YSSet<MessageId>>()
      for folderDTO in folderList {
        let folder = Folder.fromDTO(folderDTO)
        folderToMessages.set(folder.name, YSSet<MessageId>())
      }
      messageToFolder.__forEach({
        folder, msg in
        folderToMessages.get(folder.name)!.add(msg)
      })
      let accountData = AccountMailboxData(client.userAccount, messages, folderToMessages, valuesArray(threads), aliases, contacts, accountSettings)
      accountsData.push(accountData)
      logger.log("Downloading account (\(client.userAccount.login)) finished")
    }
    logger.log("Downloading mailbox finished")
    logger.log("\n")
    let accountDataHandler = MailAppModelHandler(accountsData)
    return MailboxModel(accountDataHandler)
  }
}
