// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/mailbox-preparer.ts >>>

import Foundation

open class ImapFolder {
  public var name: String
  public var messages: YSArray<ImapMessage>
  public init(_ name: String, _ messages: YSArray<ImapMessage>) {
    self.name = name
    self.messages = messages
  }

  @discardableResult
  open func toJson() -> JSONItem {
    return MapJSONItem().putString("name", name).put("messages", ArrayJSONItem(messages.map {
      m in
      m.toJson()
    }))
  }
}

open class ImapUser {
  private var email: String
  private var name: String
  public init(_ email: String, _ name: String) {
    self.email = email
    self.name = name
  }

  @discardableResult
  open func toJson() -> JSONItem {
    return MapJSONItem().putString("email", email).putString("name", name)
  }
}

open class ImapMessage {
  private var sender: ImapUser
  private var subject: String
  private var textBody: String
  private var timestamp: String
  private var toReceivers: YSArray<ImapUser>
  public init(_ builder: ImapMessageBuilder) {
    sender = requireNonNull(builder.sender, "Sender required!")
    subject = requireNonNull(builder.subject, "Subject required!")
    textBody = requireNonNull(builder.textBody, "Body text required!")
    timestamp = requireNonNull(builder.timestamp, "Timestamp required!")
    toReceivers = builder.toReceivers
  }

  @discardableResult
  open class func builder() -> ImapMessageBuilder {
    return ImapMessageBuilder()
  }

  @discardableResult
  open class func create(_ subject: String, _ timestamp: String! = nil) -> ImapMessage {
    return builder().withSender(ImapUser("other.user@ya.ru", "Other User")).withSubject(subject).withTextBody("first line").withTimestamp(timestamp != nil ? timestamp : "2019-07-20T17:03:06.000Z").build()
  }

  @discardableResult
  open func toJson() -> JSONItem {
    return MapJSONItem().put("sender", sender.toJson()).putString("subject", subject).putString("textBody", textBody).putString("timestamp", timestamp).put("toReceivers", ArrayJSONItem(toReceivers.map {
      r in
      r.toJson()
    }))
  }
}

open class ImapMessageBuilder {
  public var sender: ImapUser!
  public var subject: String!
  public var textBody: String!
  public var timestamp: String!
  public var toReceivers: YSArray<ImapUser> = YSArray()
  @discardableResult
  open func withSender(_ sender: ImapUser) -> ImapMessageBuilder {
    self.sender = sender
    return self
  }

  @discardableResult
  open func withSubject(_ subject: String) -> ImapMessageBuilder {
    self.subject = subject
    return self
  }

  @discardableResult
  open func withTextBody(_ textBody: String) -> ImapMessageBuilder {
    self.textBody = textBody
    return self
  }

  @discardableResult
  open func withTimestamp(_ timestamp: String) -> ImapMessageBuilder {
    self.timestamp = timestamp
    return self
  }

  @discardableResult
  open func addReceiver(_ receiver: ImapUser) -> ImapMessageBuilder {
    toReceivers.push(receiver)
    return self
  }

  @discardableResult
  open func build() -> ImapMessage {
    return ImapMessage(self)
  }
}

open class ImapMailAccount {
  private var host: String
  public var login: String
  public let password: String
  public init(_ host: String, _ login: String, _ password: String) {
    self.host = host
    self.login = login
    self.password = password
  }

  @discardableResult
  open func toJson() -> JSONItem {
    return MapJSONItem().putString("host", host).putString("login", login).putString("password", password)
  }
}

open class ImapMailbox {
  public var mailAccount: ImapMailAccount
  public var folders: YSArray<ImapFolder> = YSArray()
  public init(_ builder: ImapMailboxBuilder) {
    mailAccount = builder.mailAccount
    builder.folders.__forEach {
      messages, name in
      self.folders.push(ImapFolder(name, messages))
    }
  }

  @discardableResult
  open class func builder(_ account: UserAccount) -> ImapMailboxBuilder {
    return ImapMailboxBuilder(account.login, account.password)
  }

  @discardableResult
  open func toJson() -> MapJSONItem {
    return MapJSONItem().put("folders", ArrayJSONItem(folders.map {
      f in
      f.toJson()
    })).put("mailAccount", mailAccount.toJson())
  }
}

open class ImapMailboxBuilder {
  public let mailAccount: ImapMailAccount
  public let folders: YSMap<String, YSArray<ImapMessage>> = YSMap<String, YSArray<ImapMessage>>()
  private let timestampProvider: MessageTimeProvider = MessageTimeProvider()
  private var currentFolder: FolderName = DefaultFolderName.inbox
  public init(_ login: String, _ password: String) {
    mailAccount = ImapMailAccount("imap.yandex.ru", login, password)
  }

  @discardableResult
  open func nextMessage(_ subject: String) -> ImapMailboxBuilder {
    let timestamp = timestampProvider.nextTime()
    addMessageToFolder(currentFolder, ImapMessage.create(subject, timestamp))
    return self
  }

  @discardableResult
  open func nextThread(_ subject: String, _ threadSize: Int32) -> ImapMailboxBuilder {
    let timestamp = timestampProvider.nextTime()
    for i in stride(from: 0, to: threadSize, by: 1) {
      addMessageToFolder(currentFolder, ImapMessage.create(subject, timestamp))
    }
    return self
  }

  @discardableResult
  open func switchFolder(_ folder: FolderName) -> ImapMailboxBuilder {
    currentFolder = folder
    return self
  }

  @discardableResult
  open func addMessageToFolder(_ folder: FolderName, _ message: ImapMessage) -> ImapMailboxBuilder {
    if !folders.has(folder) {
      folders.set(folder, YSArray())
    }
    let folderMessage = folders.get(folder)!
    folderMessage.push(message)
    return self
  }

  @discardableResult
  open func build() -> ImapMailbox {
    return ImapMailbox(self)
  }
}

open class BasePrepareMailboxRequest: NetworkRequest {
  private var mailbox: ImapMailbox
  public init(_ mailbox: ImapMailbox) {
    self.mailbox = mailbox
  }

  @discardableResult
  open func encoding() -> RequestEncoding {
    return JsonRequestEncoding()
  }

  @discardableResult
  open func method() -> NetworkMethod {
    return NetworkMethod.post
  }

  @discardableResult
  open func params() -> MapJSONItem {
    return mailbox.toJson()
  }

  @discardableResult
  open func urlExtra() -> MapJSONItem {
    return MapJSONItem()
  }

  @discardableResult
  open func version() -> NetworkAPIVersions {
    return NetworkAPIVersions.unspecified
  }

  @discardableResult
  open func path() -> String {
    fatalError("Must be overridden in subclasses")
  }
}

open class SyncPrepareMailboxRequest: BasePrepareMailboxRequest {
  public override init(_ mailbox: ImapMailbox) {
    super.init(mailbox)
  }

  @discardableResult
  open override func path() -> String {
    return "sync"
  }
}

open class AsyncPrepareMailboxRequest: BasePrepareMailboxRequest {
  public override init(_ mailbox: ImapMailbox) {
    super.init(mailbox)
  }

  @discardableResult
  open override func path() -> String {
    return "async"
  }
}

open class PrepareMailboxStatusRequest: NetworkRequest {
  private var id: String
  public init(_ id: String) {
    self.id = id
  }

  @discardableResult
  open func encoding() -> RequestEncoding {
    return UrlRequestEncoding()
  }

  @discardableResult
  open func method() -> NetworkMethod {
    return NetworkMethod.get
  }

  @discardableResult
  open func params() -> MapJSONItem {
    return MapJSONItem()
  }

  @discardableResult
  open func urlExtra() -> MapJSONItem {
    return MapJSONItem()
  }

  @discardableResult
  open func version() -> NetworkAPIVersions {
    return NetworkAPIVersions.unspecified
  }

  @discardableResult
  open func path() -> String {
    return "async/\(id)"
  }
}

open class MailboxPreparer {
  private var network: SyncNetwork
  private var jsonSerializer: JSONSerializer
  private var sleep: SyncSleep
  private var logger: Logger
  public init(_ network: SyncNetwork, _ jsonSerializer: JSONSerializer, _ sleep: SyncSleep, _ logger: Logger) {
    self.network = network
    self.jsonSerializer = jsonSerializer
    self.sleep = sleep
    self.logger = logger
  }

  open func prepare(_ mailbox: ImapMailbox) {
    logger.log("Preparing mailbox:")
    for folder in mailbox.folders {
      for message in folder.messages {
        logger.log("\(message.toJson())")
      }
    }
    let ticket = startPreparing(mailbox)
    logger.log("Mailbox preparing started, id=\(ticket)")
    while true {
      let done = finished(ticket)
      if done {
        logger.log("Mailbox prepared")
        return
      }
      sleep.sleepMs(3000)
    }
  }

  @discardableResult
  private func syncRequest(_ networkRequest: NetworkRequest) -> MapJSONItem {
    let response = network.syncExecute(PublicBackendConfig.mailboxPreparerUrl, networkRequest, nil)
    let json = jsonSerializer.deserialize(response) {
      item in
      Result(item, nil)
    }.getValue()
    return json as! MapJSONItem
  }

  @discardableResult
  private func startPreparing(_ mailbox: ImapMailbox) -> String {
    let preparingStartedResponse = syncRequest(AsyncPrepareMailboxRequest(mailbox))
    return requireNonNull(preparingStartedResponse.getString("id"), "No \"id\" field in response!")
  }

  @discardableResult
  private func finished(_ ticket: String) -> Bool {
    let statusResponse = syncRequest(PrepareMailboxStatusRequest(ticket))
    let status = requireNonNull(statusResponse.getMap("status"), "No \"status\" field in response!")
    let message = (status.get("message") as! StringJSONItem).value
    logger.log("Mailbox preparing status: \(message)")
    return (status.get("done") as! BooleanJSONItem).value
  }
}
