// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/account-navigator-settings-actions.ts >>>

import Foundation

open class OpenAccountSettingsAction: MBTAction {
  public static let type: MBTActionType = "OpenAccountSettings"
  public var accountIndex: Int32
  public init(_ accountIndex: Int32) {
    self.accountIndex = accountIndex
  }

  @discardableResult
  open func canBePerformed(_: App) -> Bool {
    return true
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.stubEvent())
  }

  @discardableResult
  open func getActionType() -> String {
    return OpenAccountSettingsAction.type
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _: MBTHistory) -> MBTComponent {
    let modelImpl = AccountSettingsNavigatorFeature.get.forceCast(model)
    let appImpl = AccountSettingsNavigatorFeature.get.forceCast(application)
    modelImpl.openAccountSettings(accountIndex)
    appImpl.openAccountSettings(accountIndex)
    return AccountSettingsComponent()
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return AccountSettingsNavigatorFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func tostring() -> String {
    return "OpenAccountSettings"
  }
}

open class CloseAccountSettingsAction: MBTAction {
  public static let type: MBTActionType = "CloseAccountSettings"
  @discardableResult
  open func canBePerformed(_: App) -> Bool {
    return true
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.stubEvent())
  }

  @discardableResult
  open func getActionType() -> String {
    return CloseAccountSettingsAction.type
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _: MBTHistory) -> MBTComponent {
    let modelImpl = AccountSettingsNavigatorFeature.get.forceCast(model)
    let appImpl = AccountSettingsNavigatorFeature.get.forceCast(application)
    modelImpl.closeAccountSettings()
    appImpl.closeAccountSettings()
    return SettingsComponent()
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return AccountSettingsNavigatorFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func tostring() -> String {
    return "CloseAccountSettings"
  }
}
