// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/compose-message-actions.ts >>>

import Foundation

open class ComposeMessageBaseAction: BaseSimpleAction<ComposeMessage, MBTComponent> {
  public override init(_ type: MBTActionType) {
    super.init(type)
  }

  @discardableResult
  open override func requiredFeature() -> Feature<ComposeMessage> {
    return ComposeMessageFeature.get
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    fatalError("Must be overridden in subclasses")
  }
}

open class AddToAction: ComposeMessageBaseAction {
  public static let type: MBTActionType = "AddTo"
  private var to: MBTActionType
  public override init(_ to: MBTActionType) {
    self.to = to
    super.init(AddToAction.type)
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: ComposeMessage, _ currentComponent: MBTComponent) -> MBTComponent {
    modelOrApplication.addTo(to)
    return currentComponent
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.composeEvents.addReceiver())
  }

  @discardableResult
  open override func tostring() -> String {
    return "AddToAction(to=\(to))"
  }
}

open class SetSubjectAction: ComposeMessageBaseAction {
  public static let type: MBTActionType = "SetSubject"
  private var subject: MBTActionType
  public override init(_ subject: MBTActionType) {
    self.subject = subject
    super.init(SetSubjectAction.type)
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: ComposeMessage, _ currentComponent: MBTComponent) -> MBTComponent {
    modelOrApplication.setSubject(subject)
    return currentComponent
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.composeEvents.setSubject())
  }

  @discardableResult
  open override func tostring() -> String {
    return "AddSubjectAction(subject=\(subject))"
  }
}

open class SetBodyAction: ComposeMessageBaseAction {
  public static let type: MBTActionType = "SetBody"
  private var body: MBTActionType
  public override init(_ body: MBTActionType) {
    self.body = body
    super.init(SetBodyAction.type)
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: ComposeMessage, _ currentComponent: MBTComponent) -> MBTComponent {
    modelOrApplication.setBody(body)
    return currentComponent
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.composeEvents.editBody(body.length))
  }

  @discardableResult
  open override func tostring() -> String {
    return "AppendBodyAction(bodyFragment=\(body))"
  }
}

open class AddToFromSuggestAction: ComposeMessageBaseAction {
  public static let type: MBTActionType = "AddToFromSuggest"
  private var to: MBTActionType
  public override init(_ to: MBTActionType) {
    self.to = to
    super.init(AddToFromSuggestAction.type)
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: ComposeMessage, _ currentComponent: MBTComponent) -> MBTComponent {
    modelOrApplication.addToUsingSuggest(to)
    return currentComponent
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.composeEvents.addReceiver())
  }

  @discardableResult
  open override func tostring() -> String {
    return "AddToFromSuggestAction(to=\(to))"
  }
}
