// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/context-menu-actions.ts >>>

import Foundation

open class BaseContextMenuAction: MBTAction {
  public var order: Int32
  private var type: MBTActionType
  public init(_ order: Int32, _ type: MBTActionType) {
    self.order = order
    self.type = type
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return ContextMenuFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    let messageListModel = MessageListDisplayFeature.get.forceCast(model)
    let messages = messageListModel.getMessageList(10)
    return order < messages.length && canBePerformedImpl(messages[self.order])
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent {
    performImpl(ContextMenuFeature.get.forceCast(model))
    performImpl(ContextMenuFeature.get.forceCast(application))
    return history.currentComponent
  }

  @discardableResult
  open func canBePerformedImpl(_: MessageView) -> Bool {
    fatalError("Must be overridden in subclasses")
  }

  open func performImpl(_: ContextMenu) {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func tostring() -> String {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return type
  }
}

open class DeleteMessageFromContextMenuAction: BaseContextMenuAction {
  public static let type: MBTActionType = "DeleteMessageFromContextMenu"
  public init(_ order: Int32) {
    super.init(order, DeleteMessageFromContextMenuAction.type)
  }

  open override func performImpl(_ modelOrApplication: ContextMenu) {
    modelOrApplication.deleteMessageFromContextMenu(order)
  }

  @discardableResult
  open override func tostring() -> String {
    return "DeleteMessageFromContextMenu(\(order))"
  }

  @discardableResult
  open override func canBePerformedImpl(_: MessageView) -> Bool {
    return true
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageListEvents.openMessageActions(order, int64(-1)), Testopithecus.messageActionsEvents.delete())
  }
}

open class MarkAsReadFromContextMenuAction: BaseContextMenuAction {
  public static let type: MBTActionType = "MarkAsReadFromContextMenu"
  public init(_ order: Int32) {
    super.init(order, MarkAsReadFromContextMenuAction.type)
  }

  open override func performImpl(_ modelOrApplication: ContextMenu) {
    modelOrApplication.markAsReadFromContextMenu(order)
  }

  @discardableResult
  open override func tostring() -> String {
    return "MarkAsReadFromContextMenu(\(order))"
  }

  @discardableResult
  open override func canBePerformedImpl(_ message: MessageView) -> Bool {
    return MarkAsRead.canMarkRead(message)
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageListEvents.openMessageActions(order, int64(-1)), Testopithecus.messageActionsEvents.markAsRead())
  }
}

open class MarkAsUnreadFromContextMenuAction: BaseContextMenuAction {
  public static let type: MBTActionType = "MarkAsUnreadFromContextMenu"
  public init(_ order: Int32) {
    super.init(order, MarkAsUnreadFromContextMenuAction.type)
  }

  open override func performImpl(_ modelOrApplication: ContextMenu) {
    modelOrApplication.markAsUnreadFromContextMenu(order)
  }

  @discardableResult
  open override func tostring() -> String {
    return "MarkAsUnreadFromContextMenuAction(\(order))"
  }

  @discardableResult
  open override func canBePerformedImpl(_ message: MessageView) -> Bool {
    return MarkAsUnread.canMarkUnread(message)
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageListEvents.openMessageActions(order, int64(-1)), Testopithecus.messageActionsEvents.markAsUnread())
  }
}

open class MarkAsImportantFromContextMenuAction: BaseContextMenuAction {
  public static let type: MBTActionType = "MarkAsImportantFromContextMenu"
  public init(_ order: Int32) {
    super.init(order, MarkAsImportantFromContextMenuAction.type)
  }

  open override func performImpl(_ modelOrApplication: ContextMenu) {
    modelOrApplication.markAsImportantFromContextMenu(order)
  }

  @discardableResult
  open override func tostring() -> String {
    return "MarkAsImportantFromContextMenuAction(\(order))"
  }

  @discardableResult
  open override func canBePerformedImpl(_ message: MessageView) -> Bool {
    return MarkAsImportant.canMarkImportant(message)
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageListEvents.openMessageActions(order, int64(-1)), Testopithecus.messageActionsEvents.markAsImportant())
  }
}

open class MoveToFolderFromContextMenuAction: MBTAction {
  public static let type: MBTActionType = "MoveToFolderFromContextMenu"
  private var order: Int32
  private var folderName: String
  public init(_ order: Int32, _ folderName: String) {
    self.order = order
    self.folderName = folderName
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return FolderNavigatorFeature.get.included(modelFeatures) && MovableToFolderFeature.get.included(modelFeatures) && ContextMenuFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    let folderNavigatorModel = FolderNavigatorFeature.get.forceCast(model)
    let folders = folderNavigatorModel.getFoldersList()
    return folders.filter {
      folder in
      folder.name == self.folderName
    }.length > 0 && folderNavigatorModel.getCurrentFolder().name != folderName
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageListEvents.openMessageActions(order, int64(-1)), Testopithecus.messageActionsEvents.moveToFolder())
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent {
    ContextMenuFeature.get.forceCast(model).moveToFolderFromContextMenu(order, folderName)
    ContextMenuFeature.get.forceCast(application).moveToFolderFromContextMenu(order, folderName)
    return history.currentComponent
  }

  @discardableResult
  open func tostring() -> String {
    return "MovableToFolderFromContextMenuAction(\(order) \(folderName))"
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return MoveToFolderFromContextMenuAction.type
  }
}
