// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/delete-message.ts >>>

import Foundation

open class DeleteMessageAction: BaseSimpleAction<DeleteMessage, MaillistComponent> {
  public static let type: MBTActionType = "DeleteMessage"
  private var order: Int32
  public init(_ order: Int32) {
    self.order = order
    super.init(DeleteMessageAction.type)
  }

  @discardableResult
  open override func requiredFeature() -> Feature<DeleteMessage> {
    return DeleteMessageFeature.get
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.stubEvent())
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: DeleteMessage, _ currentComponent: MaillistComponent) -> MBTComponent {
    modelOrApplication.deleteMessage(order)
    return currentComponent
  }

  @discardableResult
  open override func tostring() -> String {
    return "DeleteMessage(\(order))"
  }
}

open class DeleteCurrentMessage: BaseSimpleAction<MessageNavigator, MessageComponent> {
  public static let type: MBTActionType = "DeleteCurrentMessage"
  public init() {
    super.init(DeleteCurrentMessage.type)
  }

  @discardableResult
  open override func requiredFeature() -> Feature<MessageNavigator> {
    return MessageNavigatorFeature.get
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageViewEvents.deleteMessage())
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: MessageNavigator, _: MessageComponent) -> MBTComponent {
    modelOrApplication.deleteCurrentMessage()
    return MaillistComponent()
  }
}
