// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/folder-navigator-actions.ts >>>

import Foundation

open class GoToFolderAction: MBTAction {
  public static let type: MBTActionType = "GoToFolder"
  private var folderName: String
  public init(_ folderName: String) {
    self.folderName = folderName
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    let folderNavigatorModel = FolderNavigatorFeature.get.forceCast(model)
    let folders = folderNavigatorModel.getFoldersList()
    return folders.filter {
      folder in
      folder.name == self.folderName
    }.length > 0
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.stubEvent())
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _: MBTHistory) -> MBTComponent {
    FolderNavigatorFeature.get.forceCast(model).goToFolder(folderName)
    FolderNavigatorFeature.get.forceCast(application).goToFolder(folderName)
    return MaillistComponent()
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return FolderNavigatorFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return GoToFolderAction.type
  }

  @discardableResult
  open func tostring() -> String {
    return "GoToFolder(\(folderName))"
  }
}

open class CreateFolderAction: MBTAction {
  public static let type: MBTActionType = "CreateFolder"
  private var folderName: String
  public init(_ folderName: String) {
    self.folderName = folderName
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    let folderNavigatorModel = FolderNavigatorFeature.get.forceCast(model)
    let folders = folderNavigatorModel.getFoldersList()
    return folders.filter {
      folder in
      folder.name == self.folderName
    }.length == 0
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.stubEvent())
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent {
    CreatableFolderFeature.get.forceCast(model).createFolder(folderName)
    CreatableFolderFeature.get.forceCast(application).createFolder(folderName)
    return history.currentComponent
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return FolderNavigatorFeature.get.includedAll(modelFeatures, applicationFeatures) && CreatableFolderFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return CreateFolderAction.type
  }

  @discardableResult
  open func tostring() -> String {
    return "CreateFolder(\(folderName))"
  }
}
