// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/group-by-subject-action.ts >>>

import Foundation

open class BaseGroupBySubjectAction: MBTAction {
  private var type: MBTActionType
  public init(_ type: MBTActionType) {
    self.type = type
  }

  @discardableResult
  open func canBePerformed(_: App) -> Bool {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.stubEvent())
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent {
    performImpl(model)
    performImpl(application)
    return history.currentComponent
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return GroupBySubjectFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  open func performImpl(_: App) {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func getActionType() -> MBTComponentType {
    return type
  }

  @discardableResult
  open func tostring() -> String {
    return getActionType()
  }
}

open class SwitchOnThreadingAction: BaseGroupBySubjectAction {
  public static let type: MBTActionType = "SwitchOnThreading"
  public init() {
    super.init(SwitchOnThreadingAction.type)
  }

  @discardableResult
  open override func canBePerformed(_ model: App) -> Bool {
    let groupBySybjectModel = GroupBySubjectFeature.get.forceCast(model)
    return !groupBySybjectModel.getThreadingSetting()
  }

  open override func performImpl(_ modelOrApplication: App) {
    let modelOrAppImpl = GroupBySubjectFeature.get.forceCast(modelOrApplication)
    modelOrAppImpl.toggleThreadingSetting()
  }
}

open class SwitchOffThreadingAction: BaseGroupBySubjectAction {
  public static let type: MBTActionType = "SwitchOffThreading"
  public init() {
    super.init(SwitchOffThreadingAction.type)
  }

  @discardableResult
  open override func canBePerformed(_ model: App) -> Bool {
    let groupBySybjectModel = GroupBySubjectFeature.get.forceCast(model)
    return groupBySybjectModel.getThreadingSetting()
  }

  open override func performImpl(_ modelOrApplication: App) {
    let modelOrAppImpl = GroupBySubjectFeature.get.forceCast(modelOrApplication)
    modelOrAppImpl.toggleThreadingSetting()
  }
}

open class GetThreadingSetting {
  @discardableResult
  open func canBePerformed(_: App) -> Bool {
    return true
  }

  open func performImpl(_ modelOrApplication: App) {
    let modelOrAppImpl = GroupBySubjectFeature.get.forceCast(modelOrApplication)
    modelOrAppImpl.getThreadingSetting()
  }

  @discardableResult
  open func tostring() -> String {
    return "GetThreadingSetting"
  }
}
