// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/group-mode-actions.ts >>>

import Foundation

open class BaseGroupModeAction: MBTAction {
  private var type: MBTActionType
  public init(_ type: MBTActionType) {
    self.type = type
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return GroupModeFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    let groupModeModel = GroupModeFeature.get.forceCast(model)
    let messageListModel = MessageListDisplayFeature.get.forceCast(model)
    let foldersModel = FolderNavigatorFeature.get.forceCast(model)
    let messages = messageListModel.getMessageList(10)
    let selectedMessageOrders = groupModeModel.getSelectedMessages()
    if selectedMessageOrders == nil {
      return false
    }
    let selectedMessages: YSArray<MessageView> = YSArray()
    for order in selectedMessageOrders.values() {
      selectedMessages.push(messages[order])
    }
    let currentFolder = foldersModel.getCurrentFolder()
    return canBePerformedImpl(selectedMessages, selectedMessageOrders, currentFolder)
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _: MBTHistory) -> MBTComponent {
    performImpl(GroupModeFeature.get.forceCast(model))
    performImpl(GroupModeFeature.get.forceCast(application))
    return MaillistComponent()
  }

  @discardableResult
  open func canBePerformedImpl(_: YSArray<MessageView>, _: YSSet<Int32>, _: Folder) -> Bool {
    fatalError("Must be overridden in subclasses")
  }

  open func performImpl(_: GroupMode) {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func tostring() -> String {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return type
  }
}

open class BaseMarkSelectedMessages: MBTAction {
  private var type: MBTActionType
  public init(_ type: MBTActionType) {
    self.type = type
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return MessageListDisplayFeature.get.included(modelFeatures) && GroupModeFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    let messageListModel = MessageListDisplayFeature.get.forceCast(model)
    let groupModeModel = GroupModeFeature.get.forceCast(model)
    let selectedMessageOrders = groupModeModel.getSelectedMessages()
    if selectedMessageOrders == nil {
      return false
    }
    let messages = messageListModel.getMessageList(10)
    let unreadCount = filterByOrders(messages, selectedMessageOrders).filter {
      message in
      !message.read
    }.length
    return canBePerformedImpl(unreadCount)
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _: MBTHistory) -> MBTComponent {
    performImpl(GroupModeFeature.get.forceCast(model))
    performImpl(GroupModeFeature.get.forceCast(application))
    return MaillistComponent()
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func canBePerformedImpl(_: Int32) -> Bool {
    fatalError("Must be overridden in subclasses")
  }

  open func performImpl(_: GroupMode) {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func tostring() -> String {
    return getActionType()
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return type
  }
}

open class InitialSelectMessage: BaseSimpleAction<GroupMode, MaillistComponent> {
  public static let type: MBTActionType = "InitialSelectMessages"
  private var order: Int32
  public init(_ order: Int32) {
    self.order = order
    super.init(SelectMessage.type)
  }

  @discardableResult
  open override func requiredFeature() -> Feature<GroupMode> {
    return GroupModeFeature.get
  }

  @discardableResult
  open override func canBePerformedImpl(_ model: GroupMode) -> Bool {
    return !model.isInGroupMode()
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.groupActionsEvents.selectMessage(order, int64(-1)))
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: GroupMode, _: MaillistComponent) -> MBTComponent {
    modelOrApplication.initialMessageSelect(order)
    return GroupOperationsComponent()
  }

  @discardableResult
  open override func tostring() -> String {
    return "InitialSelectMessage(\(order))"
  }
}

open class SelectMessage: BaseSimpleAction<GroupMode, GroupOperationsComponent> {
  public static let type: MBTActionType = "SelectMessages"
  private var order: Int32
  public init(_ order: Int32) {
    self.order = order
    super.init(SelectMessage.type)
  }

  @discardableResult
  open override func requiredFeature() -> Feature<GroupMode> {
    return GroupModeFeature.get
  }

  @discardableResult
  open override func canBePerformedImpl(_ model: GroupMode) -> Bool {
    return model.isInGroupMode()
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.groupActionsEvents.selectMessage(order, int64(-1)))
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: GroupMode, _: GroupOperationsComponent) -> MBTComponent {
    modelOrApplication.selectMessage(order)
    return GroupOperationsComponent()
  }

  @discardableResult
  open override func tostring() -> String {
    return "SelectMessages(\(order))"
  }
}

open class MarkAsReadSelectedMessages: BaseMarkSelectedMessages {
  public static let type: MBTActionType = "MarkAsReadSelectedMessages"
  public init() {
    super.init(MarkAsReadSelectedMessages.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_ selectedUnreadCount: Int32) -> Bool {
    return selectedUnreadCount > 0
  }

  open override func performImpl(_ modelOrApplication: GroupMode) {
    modelOrApplication.markAsReadSelectedMessages()
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.groupActionsEvents.markAsReadSelectedMessages())
  }
}

open class MarkAsUnreadSelectedMessages: BaseMarkSelectedMessages {
  public static let type: MBTActionType = "MarkAsUnreadSelectedMessages"
  public init() {
    super.init(MarkAsUnreadSelectedMessages.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_ selectedUnreadCount: Int32) -> Bool {
    return selectedUnreadCount == 0
  }

  open override func performImpl(_ modelOrApplication: GroupMode) {
    modelOrApplication.markAsUnreadSelectedMessages()
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.groupActionsEvents.markAsUnreadSelectedMessages())
  }
}

open class DeleteSelectedMessages: MBTAction {
  public static let type: MBTActionType = "DeleteSelectedMessages"
  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return MessageListDisplayFeature.get.included(modelFeatures) && GroupModeFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_: App) -> Bool {
    return true
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _: MBTHistory) -> MBTComponent {
    GroupModeFeature.get.forceCast(model).deleteSelectedMessages()
    GroupModeFeature.get.forceCast(application).deleteSelectedMessages()
    return MaillistComponent()
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.groupActionsEvents.deleteSelectedMessages())
  }

  @discardableResult
  open func tostring() -> String {
    return getActionType()
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return DeleteSelectedMessages.type
  }
}

open class MarkImportantSelectedAction: BaseGroupModeAction {
  public static let type: MBTActionType = "MarkImportantSelected"
  public init() {
    super.init(MarkImportantSelectedAction.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_ messages: YSArray<MessageView>, _: YSSet<Int32>, _: Folder) -> Bool {
    return messages.map {
      m in
      !m.important
    }.includes(true)
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray()
  }

  open override func performImpl(_ modelOrApplication: GroupMode) {
    modelOrApplication.markAsImportantSelectedMessages()
  }

  @discardableResult
  open override func tostring() -> String {
    return MarkImportantSelectedAction.type
  }
}

open class MarkUnimportantSelectedAction: BaseGroupModeAction {
  public static let type: MBTActionType = "MarkUnimportantSelected"
  public init() {
    super.init(MarkUnimportantSelectedAction.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_ messages: YSArray<MessageView>, _: YSSet<Int32>, _: Folder) -> Bool {
    return messages.map {
      m in
      !m.important
    }.includes(false)
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray()
  }

  open override func performImpl(_ modelOrApplication: GroupMode) {
    modelOrApplication.markAsUnImportantSelectedMessages()
  }

  @discardableResult
  open override func tostring() -> String {
    return MarkUnimportantSelectedAction.type
  }
}

open class MarkSpamSelectedAction: BaseGroupModeAction {
  public static let type: MBTActionType = "MarkSpamSelected"
  public init() {
    super.init(MarkSpamSelectedAction.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_: YSArray<MessageView>, _: YSSet<Int32>, _ currentFolder: Folder) -> Bool {
    return currentFolder.name != DefaultFolderName.spam
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray()
  }

  open override func performImpl(_ modelOrApplication: GroupMode) {
    modelOrApplication.markAsSpamSelectedMessages()
  }

  @discardableResult
  open override func tostring() -> String {
    return MarkSpamSelectedAction.type
  }
}

open class MarkNotSpamSelectedAction: BaseGroupModeAction {
  public static let type: MBTActionType = "MarkNotSpamSelected"
  public init() {
    super.init(MarkNotSpamSelectedAction.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_: YSArray<MessageView>, _: YSSet<Int32>, _ currentFolder: Folder) -> Bool {
    return currentFolder.name == DefaultFolderName.spam
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray()
  }

  open override func performImpl(_ modelOrApplication: GroupMode) {
    modelOrApplication.markAsNotSpamSelectedMessages()
  }

  @discardableResult
  open override func tostring() -> String {
    return MarkNotSpamSelectedAction.type
  }
}

open class MoveToFolderSelectedMessagesAction: MBTAction {
  public static let type: MBTActionType = "MoveToFolderSelectedMessages"
  private var folderName: FolderName
  public init(_ folderName: FolderName) {
    self.folderName = folderName
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    return FolderNavigatorFeature.get.castIfSupported(model)!.getCurrentFolder().name != folderName
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray()
  }

  @discardableResult
  open func getActionType() -> String {
    return MoveToFolderSelectedMessagesAction.type
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _: MBTHistory) -> MBTComponent {
    GroupModeFeature.get.forceCast(model).moveToFolderSelectedMessages(folderName)
    GroupModeFeature.get.forceCast(application).moveToFolderSelectedMessages(folderName)
    return MessageComponent()
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return MessageListDisplayFeature.get.included(modelFeatures) && GroupModeFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func tostring() -> String {
    return "\(MoveToFolderSelectedMessagesAction.type)(\(folderName))"
  }
}

open class UnselectMessageAction: BaseGroupModeAction {
  public static let type: MBTActionType = "UnselectMessages"
  private var order: Int32
  public init(_ order: Int32) {
    self.order = order
    super.init(UnselectMessageAction.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_: YSArray<MessageView>, _ selectedOrders: YSSet<Int32>, _: Folder) -> Bool {
    return selectedOrders.has(order)
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray()
  }

  @discardableResult
  open override func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent {
    performImpl(GroupModeFeature.get.forceCast(model))
    performImpl(GroupModeFeature.get.forceCast(application))
    if GroupModeFeature.get.forceCast(model).getSelectedMessages() == nil {
      return MessageComponent()
    } else {
      return history.currentComponent
    }
  }

  open override func performImpl(_ modelOrApplication: GroupMode) {
    modelOrApplication.unselectMessage(order)
  }

  @discardableResult
  open override func tostring() -> String {
    return "\(UnselectMessageAction.type)(\(order))"
  }
}

open class UnselectAllMessagesAction: BaseGroupModeAction {
  public static let type: MBTActionType = "UnselectAllMessages"
  public init() {
    super.init(UnselectAllMessagesAction.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_: YSArray<MessageView>, _: YSSet<Int32>, _: Folder) -> Bool {
    return true
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray()
  }

  open override func performImpl(_ modelOrApplication: GroupMode) {
    modelOrApplication.unselectAllMessages()
  }

  @discardableResult
  open override func tostring() -> String {
    return UnselectAllMessagesAction.type
  }
}
