// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/login-actions.ts >>>

import Foundation

open class LoginAction<T>: MBTAction {
  public var account: UserAccount
  public var feature: Feature<T>
  public init(_ account: UserAccount, _ feature: Feature<T>) {
    self.account = account
    self.feature = feature
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return feature.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_: App) -> Bool {
    return true
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.startEvents.startWithMessageListShow())
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _: MBTHistory) -> MBTComponent {
    performImpl(feature.forceCast(model))
    performImpl(feature.forceCast(application))
    return MaillistComponent()
  }

  @discardableResult
  open func tostring() -> String {
    return "\(getActionType())(login=\(account.login), password=\(account.password))"
  }

  @discardableResult
  open func getActionType() -> String {
    fatalError("Must be overridden in subclasses")
  }

  open func performImpl(_: T) {
    fatalError("Must be overridden in subclasses")
  }
}

open class YandexLoginAction: LoginAction<YandexLogin> {
  public static let type: String = "YandexLogin"
  public init(_ account: UserAccount) {
    super.init(account, YandexLoginFeature.get)
  }

  open override func performImpl(_ modelOrApplication: YandexLogin) {
    modelOrApplication.loginWithYandexAccount(account)
  }

  @discardableResult
  open override func getActionType() -> String {
    return YandexLoginAction.type
  }
}

open class MailRuLoginAction: LoginAction<MailRuLogin> {
  public static let type: String = "MailRuLogin"
  public init(_ account: UserAccount) {
    super.init(account, MailRuLoginFeature.get)
  }

  open override func performImpl(_ modelOrApplication: MailRuLogin) {
    modelOrApplication.loginWithMailRuAccount(account)
  }

  @discardableResult
  open override func getActionType() -> String {
    return MailRuLoginAction.type
  }
}

open class GoogleLoginAction: LoginAction<GoogleLogin> {
  public static let type: String = "GoogleLogin"
  public init(_ account: UserAccount) {
    super.init(account, GoogleLoginFeature.get)
  }

  open override func performImpl(_ modelOrApplication: GoogleLogin) {
    modelOrApplication.loginWithGoogleAccount(account)
  }

  @discardableResult
  open override func getActionType() -> String {
    return GoogleLoginAction.type
  }
}

open class OutlookLoginAction: LoginAction<OutlookLogin> {
  public static let type: String = "OutlookLogin"
  public init(_ account: UserAccount) {
    super.init(account, OutlookLoginFeature.get)
  }

  open override func performImpl(_ modelOrApplication: OutlookLogin) {
    modelOrApplication.loginWithOutlookAccount(account)
  }

  @discardableResult
  open override func getActionType() -> String {
    return OutlookLoginAction.type
  }
}

open class HotmailLoginAction: LoginAction<HotmailLogin> {
  public static let type: String = "HotmailLogin"
  public init(_ account: UserAccount) {
    super.init(account, HotmailLoginFeature.get)
  }

  open override func performImpl(_ modelOrApplication: HotmailLogin) {
    modelOrApplication.loginWithHotmailAccount(account)
  }

  @discardableResult
  open override func getActionType() -> String {
    return HotmailLoginAction.type
  }
}

open class RamblerlLoginAction: LoginAction<RamblerLogin> {
  public static let type: String = "RamblerLogin"
  public init(_ account: UserAccount) {
    super.init(account, RamblerLoginFeature.get)
  }

  open override func performImpl(_ modelOrApplication: RamblerLogin) {
    modelOrApplication.loginWithRamblerAccount(account)
  }

  @discardableResult
  open override func getActionType() -> String {
    return RamblerlLoginAction.type
  }
}

open class YahooLoginAction: LoginAction<YahooLogin> {
  public static let type: String = "YahooLogin"
  public init(_ account: UserAccount) {
    super.init(account, YahooLoginFeature.get)
  }

  open override func performImpl(_ modelOrApplication: YahooLogin) {
    modelOrApplication.loginWithYahooAccount(account)
  }

  @discardableResult
  open override func getActionType() -> String {
    return YandexLoginAction.type
  }
}

open class CustomMailServiceLoginAction: LoginAction<CustomMailServiceLogin> {
  public static let type: String = "CustomMailServiceLogin"
  public init(_ account: UserAccount) {
    super.init(account, CustomMailServiceLoginFeature.get)
  }

  open override func performImpl(_ modelOrApplication: CustomMailServiceLogin) {
    modelOrApplication.loginWithCustomMailServiceAccount(account)
  }

  @discardableResult
  open override func getActionType() -> String {
    return CustomMailServiceLoginAction.type
  }
}
