// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/markable-actions.ts >>>

import Foundation

open class BaseMarkAction: MBTAction {
  public var order: Int32
  public init(_ order: Int32) {
    self.order = order
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return MessageListDisplayFeature.get.included(modelFeatures) && MarkableReadFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    let messageListModel = MessageListDisplayFeature.get.forceCast(model)
    let messages = messageListModel.getMessageList(10)
    return order < messages.length && canBePerformedImpl(messages[self.order])
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent {
    performImpl(MarkableReadFeature.get.forceCast(model))
    performImpl(MarkableReadFeature.get.forceCast(application))
    return history.currentComponent
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func canBePerformedImpl(_: MessageView) -> Bool {
    fatalError("Must be overridden in subclasses")
  }

  open func performImpl(_: MarkableRead) {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func tostring() -> String {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    fatalError("Must be overridden in subclasses")
  }
}

open class MarkAsRead: BaseMarkAction {
  public static let type: MBTActionType = "MarkAsRead"
  public override init(_ order: Int32) {
    super.init(order)
  }

  @discardableResult
  open class func canMarkRead(_ message: MessageView) -> Bool {
    return !message.read
  }

  @discardableResult
  open override func canBePerformedImpl(_ message: MessageView) -> Bool {
    return MarkAsRead.canMarkRead(message)
  }

  open override func performImpl(_ modelOrApplication: MarkableRead) {
    return modelOrApplication.markAsRead(order)
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageListEvents.markMessageAsRead(order, int64(-1)))
  }

  @discardableResult
  open override func tostring() -> String {
    return "MarkAsRead(#\(order))"
  }

  @discardableResult
  open override func getActionType() -> MBTActionType {
    return MarkAsRead.type
  }
}

open class MarkAsUnread: BaseMarkAction {
  public static let type: MBTActionType = "MarkAsUnread"
  public override init(_ order: Int32) {
    super.init(order)
  }

  @discardableResult
  open class func canMarkUnread(_ message: MessageView) -> Bool {
    return message.read
  }

  @discardableResult
  open override func canBePerformedImpl(_ message: MessageView) -> Bool {
    return MarkAsUnread.canMarkUnread(message)
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageListEvents.markMessageAsUnread(order, int64(-1)))
  }

  open override func performImpl(_ modelOrApplication: MarkableRead) {
    return modelOrApplication.markAsUnread(order)
  }

  @discardableResult
  open override func tostring() -> String {
    return "MarkAsUnread(#\(order))"
  }

  @discardableResult
  open override func getActionType() -> MBTActionType {
    return MarkAsUnread.type
  }
}
