// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/message-list-actions.ts >>>

import Foundation

open class RefreshMessageListAction: BaseSimpleAction<MessageListDisplay, MBTComponent> {
  public static let type: MBTActionType = "RefreshMessageList"
  public init() {
    super.init(RefreshMessageListAction.type)
  }

  @discardableResult
  open override func requiredFeature() -> Feature<MessageListDisplay> {
    return MessageListDisplayFeature.get
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: MessageListDisplay, _ currentComponent: MBTComponent) -> MBTComponent {
    modelOrApplication.refreshMessageList()
    return currentComponent
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageListEvents.refreshMessageList())
  }

  @discardableResult
  open override func tostring() -> String {
    return "RefreshMessageList"
  }
}

open class GoToAccountSwitcherAction: MBTAction {
  public static let type: MBTActionType = "GoToAccountSwitcher"
  @discardableResult
  open func canBePerformed(_: App) -> Bool {
    return true
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.stubEvent())
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _: MBTHistory) -> MBTComponent {
    MessageListDisplayFeature.get.forceCast(model).goToAccountSwitcher()
    MessageListDisplayFeature.get.forceCast(application).goToAccountSwitcher()
    return AccountSwitcherComponent()
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return MessageListDisplayFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return GoToAccountSwitcherAction.type
  }

  @discardableResult
  open func tostring() -> String {
    return getActionType()
  }
}
