// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/movable-to-folder-actions.ts >>>

import Foundation

open class MoveToFolderAction: MBTAction {
  public static let type: MBTActionType = "MoveToFolder"
  private var order: Int32
  private var folderName: String
  public init(_ order: Int32, _ folderName: String) {
    self.order = order
    self.folderName = folderName
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return FolderNavigatorFeature.get.included(modelFeatures) && MovableToFolderFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    let folderNavigatorModel = FolderNavigatorFeature.get.forceCast(model)
    let folders = folderNavigatorModel.getFoldersList()
    return folders.filter {
      folder in
      folder.name == self.folderName
    }.length > 0 && folderNavigatorModel.getCurrentFolder().name != folderName
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageListEvents.openMessageActions(order, int64(-1)), Testopithecus.messageActionsEvents.moveToFolder())
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent {
    MovableToFolderFeature.get.forceCast(model).moveMessageToFolder(order, folderName)
    MovableToFolderFeature.get.forceCast(application).moveMessageToFolder(order, folderName)
    return history.currentComponent
  }

  @discardableResult
  open func tostring() -> String {
    return "MovableToFolderAction(\(order) \(folderName))"
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return MoveToFolderAction.type
  }
}
