// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/multi-account-actions.ts >>>

import Foundation

open class MultiAccountAction: MBTAction {
  public init() {}

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.stubEvent())
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return MultiAccountFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func perform(_: App, _: App, _: MBTHistory) -> MBTComponent {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func canBePerformed(_: App) -> Bool {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func tostring() -> String {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func getActionType() -> String {
    fatalError("Must be overridden in subclasses")
  }
}

open class SwitchAccountAction: MultiAccountAction {
  public static let type: MBTActionType = "SwitchAccount"
  private var login: String
  public init(_ login: String) {
    self.login = login
    super.init()
  }

  @discardableResult
  open override func canBePerformed(_ model: App) -> Bool {
    return MultiAccountFeature.get.forceCast(model).getLoggedInAccountsList().includes(login)
  }

  @discardableResult
  open override func perform(_ model: App, _ application: App, _: MBTHistory) -> MBTComponent {
    performImpl(model)
    performImpl(application)
    return MaillistComponent()
  }

  @discardableResult
  open override func tostring() -> String {
    return "SwitchAccountAction(login=\(login))"
  }

  @discardableResult
  open override func getActionType() -> String {
    return SwitchAccountAction.type
  }

  private func performImpl(_ modelOrApplication: App) {
    MultiAccountFeature.get.forceCast(modelOrApplication).switchToAccount(login)
  }
}

open class AddNewAccountAction: MultiAccountAction {
  public static let type: MBTActionType = "AddNewAccount"
  public override init() {
    super.init()
  }

  @discardableResult
  open override func canBePerformed(_: App) -> Bool {
    return true
  }

  @discardableResult
  open override func perform(_ model: App, _ application: App, _: MBTHistory) -> MBTComponent {
    performImpl(model)
    performImpl(application)
    return LoginComponent()
  }

  @discardableResult
  open override func tostring() -> String {
    return "AddNewAccountAction"
  }

  @discardableResult
  open override func getActionType() -> String {
    return AddNewAccountAction.type
  }

  private func performImpl(_ modelOrApplication: App) {
    MultiAccountFeature.get.forceCast(modelOrApplication).addNewAccount()
  }
}
