// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/open-message.ts >>>

import Foundation

open class OpenMessage: MBTAction {
  public static let type: MBTActionType = "OpenMessage"
  private var order: Int32
  public init(_ order: Int32) {
    self.order = order
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return MessageNavigatorFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    let groupModeModel: GroupMode! = GroupModeFeature.get.castIfSupported(model)
    return groupModeModel == nil || !groupModeModel!.isInGroupMode()
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _: MBTHistory) -> MBTComponent {
    MessageNavigatorFeature.get.forceCast(model).openMessage(order)
    MessageNavigatorFeature.get.forceCast(application).openMessage(order)
    return MessageComponent()
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageListEvents.openMessage(order, int64(-1)))
  }

  @discardableResult
  open func tostring() -> String {
    return "OpenMessage(\(order))"
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return OpenMessage.type
  }
}

open class BackToMaillist: BaseSimpleAction<MessageNavigator, MBTComponent> {
  public static let type: MBTActionType = "BackToMaillist"
  public init() {
    super.init(BackToMaillist.type)
  }

  @discardableResult
  open override func requiredFeature() -> Feature<MessageNavigator> {
    return MessageNavigatorFeature.get
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: MessageNavigator, _: MBTComponent) -> MBTComponent {
    modelOrApplication.closeMessage()
    return MaillistComponent()
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageViewEvents.backToMailList())
  }
}

open class GoToMessageReply: BaseSimpleAction<ComposeMessage, MessageComponent> {
  public static let type: MBTActionType = "GoToMessageReply"
  public init() {
    super.init(GoToMessageReply.type)
  }

  @discardableResult
  open override func requiredFeature() -> Feature<ComposeMessage> {
    return ComposeMessageFeature.get
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: ComposeMessage, _: MessageComponent) -> MBTComponent {
    modelOrApplication.goToMessageReply()
    return ComposeComponent()
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageViewEvents.reply(0))
  }
}
