// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/rotatable-actions.ts >>>

import Foundation

open class RotatableAction: BaseSimpleAction<Rotatable, MBTComponent> {
  public override init(_ type: MBTActionType) {
    super.init(type)
  }

  open class func addActions(_ actions: YSArray<MBTAction>) {
    actions.push(RotateToLandscape())
    actions.push(RotateToPortrait())
  }

  @discardableResult
  open override func requiredFeature() -> Feature<Rotatable> {
    return RotatableFeature.get
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.stubEvent())
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: Rotatable, _ currentComponent: MBTComponent) -> MBTComponent {
    rotate(modelOrApplication)
    return currentComponent
  }

  open func rotate(_: Rotatable) {
    fatalError("Must be overridden in subclasses")
  }
}

open class RotateToLandscape: RotatableAction {
  public static let type: MBTActionType = "RotateToLandscape"
  public init() {
    super.init(RotateToLandscape.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_ model: Rotatable) -> Bool {
    return !model.isInLandscape()
  }

  open override func rotate(_ modelOrApplication: Rotatable) {
    modelOrApplication.rotateToLandscape()
  }
}

open class RotateToPortrait: RotatableAction {
  public static let type: MBTActionType = "RotateToPortrait"
  public init() {
    super.init(RotateToPortrait.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_ model: Rotatable) -> Bool {
    return model.isInLandscape()
  }

  open override func rotate(_ modelOrApplication: Rotatable) {
    modelOrApplication.rotateToPortrait()
  }
}
