// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/spamable-actions.ts >>>

import Foundation

open class BaseSpamAction: MBTAction {
  public var order: Int32
  private var type: MBTActionType
  public init(_ order: Int32, _ type: MBTActionType) {
    self.order = order
    self.type = type
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return MessageListDisplayFeature.get.included(modelFeatures) && FolderNavigatorFeature.get.included(modelFeatures) && SpamableFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    let messageListDisplayModel = MessageListDisplayFeature.get.forceCast(model)
    let messages = messageListDisplayModel.getMessageList(order + 1)
    return messages.length > order && canBePerformedImpl(model)
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent {
    performImpl(SpamableFeature.get.forceCast(model))
    performImpl(SpamableFeature.get.forceCast(application))
    return history.currentComponent
  }

  open func performImpl(_: Spamable) {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func canBePerformedImpl(_: App) -> Bool {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func tostring() -> String {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageListEvents.openMessageActions(order, int64(-1)))
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    fatalError("Must be overridden in subclasses")
  }
}

open class MoveFromSpamAction: BaseSpamAction {
  public static let type: MBTActionType = "MoveFromSpam"
  public init(_ order: Int32) {
    super.init(order, MoveFromSpamAction.type)
  }

  @discardableResult
  open override func getActionType() -> MBTActionType {
    return MoveFromSpamAction.type
  }

  open override func performImpl(_ modelOrApplication: Spamable) {
    modelOrApplication.moveFromSpam(order)
  }

  @discardableResult
  open override func tostring() -> String {
    return "\(MoveFromSpamAction.type)(#\(order))"
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    let events = super.events()
    events.push(Testopithecus.messageActionsEvents.markAsSpam())
    return events
  }

  @discardableResult
  open override func canBePerformedImpl(_ model: App) -> Bool {
    let folderNavigatorModel = FolderNavigatorFeature.get.forceCast(model)
    return folderNavigatorModel.getCurrentFolder().name == DefaultFolderName.spam
  }
}

open class MoveToSpamAction: BaseSpamAction {
  public static let type: MBTActionType = "MoveToSpam"
  public init(_ order: Int32) {
    super.init(order, MoveToSpamAction.type)
  }

  @discardableResult
  open override func getActionType() -> MBTActionType {
    return MoveToSpamAction.type
  }

  open override func performImpl(_ modelOrApplication: Spamable) {
    modelOrApplication.moveToSpam(order)
  }

  @discardableResult
  open override func tostring() -> String {
    return "\(MoveToSpamAction.type)(#\(order))"
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    let events = super.events()
    events.push(Testopithecus.messageActionsEvents.markAsNotSpam())
    return events
  }

  @discardableResult
  open override func canBePerformedImpl(_ model: App) -> Bool {
    let folderNavigatorModel = FolderNavigatorFeature.get.forceCast(model)
    return folderNavigatorModel.getCurrentFolder().name != DefaultFolderName.spam
  }
}
