// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/thread-markable-actions.ts >>>

import Foundation

open class AbstractExpandableThreadsAction: MBTAction {
  public var threadOrder: Int32
  private var type: MBTActionType
  public init(_ threadOrder: Int32, _ type: MBTActionType) {
    self.threadOrder = threadOrder
    self.type = type
  }

  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return ExpandableThreadsModelFeature.get.included(modelFeatures) && ExpandableThreadsFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    return canBePerformedImpl(ExpandableThreadsModelFeature.get.forceCast(model))
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent {
    performImpl(ExpandableThreadsFeature.get.forceCast(model))
    performImpl(ExpandableThreadsFeature.get.forceCast(application))
    return history.currentComponent
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.stubEvent())
  }

  @discardableResult
  open func canBePerformedImpl(_: ReadOnlyExpandableThreads) -> Bool {
    fatalError("Must be overridden in subclasses")
  }

  open func performImpl(_: ExpandableThreads) {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func tostring() -> String {
    fatalError("Must be overridden in subclasses")
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return type
  }
}

open class ExpandThreadAction: AbstractExpandableThreadsAction {
  public static let type: MBTActionType = "ExpandThread"
  public init(_ threadOrder: Int32) {
    super.init(threadOrder, ExpandThreadAction.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_ model: ReadOnlyExpandableThreads) -> Bool {
    return !model.isExpanded(threadOrder) && model.getMessagesInThread(threadOrder).length > 1
  }

  open override func performImpl(_ modelOrApplication: ExpandableThreads) {
    modelOrApplication.expandThread(threadOrder)
  }

  @discardableResult
  open override func tostring() -> String {
    return "ExpandThreadAction(\(threadOrder))"
  }
}

open class CollapseThreadAction: AbstractExpandableThreadsAction {
  public static let type: MBTActionType = "CollapseThread"
  public init(_ threadOrder: Int32) {
    super.init(threadOrder, CollapseThreadAction.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_ model: ReadOnlyExpandableThreads) -> Bool {
    return model.isExpanded(threadOrder)
  }

  open override func performImpl(_ modelOrApplication: ExpandableThreads) {
    modelOrApplication.collapseThread(threadOrder)
  }

  @discardableResult
  open override func tostring() -> String {
    return "CollapseThreadAction(\(threadOrder))"
  }
}

open class MarkAsReadExpandedAction: AbstractExpandableThreadsAction {
  public static let type: MBTActionType = "MarkAsReadExpanded"
  private var messageOrder: Int32
  public init(_ threadOrder: Int32, _ messageOrder: Int32) {
    self.messageOrder = messageOrder
    super.init(threadOrder, MarkAsReadExpandedAction.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_ model: ReadOnlyExpandableThreads) -> Bool {
    return model.isExpanded(threadOrder) && !model.isRead(threadOrder, messageOrder)
  }

  open override func performImpl(_ modelOrApplication: ExpandableThreads) {
    modelOrApplication.markThreadMessageAsRead(threadOrder, messageOrder)
  }

  @discardableResult
  open override func tostring() -> String {
    return "MarkAsReadExpandedAction(\(threadOrder), \(messageOrder))"
  }
}

open class MarkAsUnreadExpandedAction: AbstractExpandableThreadsAction {
  public static let type: MBTActionType = "MarkAsUnreadExpanded"
  private var messageOrder: Int32
  public init(_ threadOrder: Int32, _ messageOrder: Int32) {
    self.messageOrder = messageOrder
    super.init(threadOrder, MarkAsUnreadExpandedAction.type)
  }

  @discardableResult
  open override func canBePerformedImpl(_ model: ReadOnlyExpandableThreads) -> Bool {
    return model.isExpanded(threadOrder) && model.isRead(threadOrder, messageOrder)
  }

  open override func performImpl(_ modelOrApplication: ExpandableThreads) {
    modelOrApplication.markThreadMessageAsUnRead(threadOrder, messageOrder)
  }

  @discardableResult
  open override func tostring() -> String {
    return "MarkAsUnreadExpandedAction(\(threadOrder), \(messageOrder))"
  }
}
