// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/write-message-actions.ts >>>

import Foundation

open class WriteMessageBaseAction: BaseSimpleAction<WriteMessage, MBTComponent> {
  public override init(_ type: MBTActionType) {
    super.init(type)
  }

  @discardableResult
  open override func requiredFeature() -> Feature<WriteMessage> {
    return WriteMessageFeature.get
  }
}

open class SendMessageAction: WriteMessageBaseAction {
  public static let type: MBTActionType = "SendMessage"
  private var to: String
  private var subject: String
  public init(_ to: String, _ subject: String) {
    self.to = to
    self.subject = subject
    super.init(SendMessageAction.type)
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: WriteMessage, _: MBTComponent) -> MBTComponent {
    modelOrApplication.sendMessage(to, subject)
    return MaillistComponent()
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.composeEvents.sendMessage())
  }

  @discardableResult
  open override func tostring() -> String {
    return "SendMessage(to=\(to), subject=\(subject))"
  }
}

open class OpenComposeAction: WriteMessageBaseAction {
  public static let type: MBTActionType = "OpenCompose"
  public init() {
    super.init(OpenComposeAction.type)
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: WriteMessage, _: MBTComponent) -> MBTComponent {
    modelOrApplication.openCompose()
    return ComposeComponent()
  }

  @discardableResult
  open override func tostring() -> String {
    return "OpenCompose"
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.messageListEvents.writeNewMessage())
  }
}

open class ReplyMessageAction: MBTAction {
  public static let type: MBTActionType = "ReplyMessage"
  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return WriteMessageFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_: App) -> Bool {
    return true
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent {
    WriteMessageFeature.get.forceCast(model).replyMessage()
    WriteMessageFeature.get.forceCast(application).replyMessage()
    let mailListOrMessageView: MBTComponent! = history.previousDifferentComponent
    if mailListOrMessageView != nil {
      return mailListOrMessageView!
    }
    return MaillistComponent()
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.composeEvents.sendMessage())
  }

  @discardableResult
  open func tostring() -> String {
    return "ReplyMessageAction"
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return ReplyMessageAction.type
  }
}

open class SendPreparedAction: MBTAction {
  public static let type: MBTActionType = "SendPrepared"
  @discardableResult
  open func supported(_ modelFeatures: YSArray<FeatureID>, _ applicationFeatures: YSArray<FeatureID>) -> Bool {
    return ComposeMessageFeature.get.included(modelFeatures) && WriteMessageFeature.get.includedAll(modelFeatures, applicationFeatures)
  }

  @discardableResult
  open func canBePerformed(_ model: App) -> Bool {
    return ComposeMessageFeature.get.forceCast(model).getTo().size > 0
  }

  @discardableResult
  open func perform(_ model: App, _ application: App, _ history: MBTHistory) -> MBTComponent {
    WriteMessageFeature.get.forceCast(model).sendPrepared()
    WriteMessageFeature.get.forceCast(application).sendPrepared()
    return requireNonNull(history.previousDifferentComponent, "No previous screen!")
  }

  @discardableResult
  open func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.composeEvents.sendMessage())
  }

  @discardableResult
  open func tostring() -> String {
    return "SendPreparedAction"
  }

  @discardableResult
  open func getActionType() -> MBTActionType {
    return SendMessageAction.type
  }
}
