// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/actions/wysiwyg-actions.ts >>>

import Foundation

open class WysiwygBaseAction: BaseSimpleAction<WYSIWIG, MBTComponent> {
  public override init(_ type: MBTActionType) {
    super.init(type)
  }

  @discardableResult
  open override func requiredFeature() -> Feature<WYSIWIG> {
    return WysiwygFeature.get
  }

  @discardableResult
  open override func events() -> YSArray<TestopithecusEvent> {
    return YSArray(Testopithecus.stubEvent())
  }
}

open class ClearFormatting: WysiwygBaseAction {
  public static let type: MBTActionType = "ClearFormatting"
  private var from: Int32
  private var to: Int32
  public init(_ from: Int32, _ to: Int32) {
    self.from = from
    self.to = to
    super.init(ClearFormatting.type)
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: WYSIWIG, _: MBTComponent) -> MBTComponent {
    modelOrApplication.clearFormatting(from, to)
    return ComposeComponent()
  }

  @discardableResult
  open override func tostring() -> String {
    return "ClearFormatting(from=\(from), to=\(to))"
  }
}

open class SetStrong: WysiwygBaseAction {
  public static let type: MBTActionType = "SetStrong"
  private var from: Int32
  private var to: Int32
  public init(_ from: Int32, _ to: Int32) {
    self.from = from
    self.to = to
    super.init(SetStrong.type)
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: WYSIWIG, _: MBTComponent) -> MBTComponent {
    modelOrApplication.setStrong(from, to)
    return ComposeComponent()
  }

  @discardableResult
  open override func tostring() -> String {
    return "SetStrong(from=\(from), to=\(to))"
  }
}

open class SetItalic: WysiwygBaseAction {
  public static let type: MBTActionType = "SetItalic"
  private var from: Int32
  private var to: Int32
  public init(_ from: Int32, _ to: Int32) {
    self.from = from
    self.to = to
    super.init(SetItalic.type)
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: WYSIWIG, _: MBTComponent) -> MBTComponent {
    modelOrApplication.setItalic(from, to)
    return ComposeComponent()
  }

  @discardableResult
  open override func tostring() -> String {
    return "SetItalic(from=\(from), to=\(to))"
  }
}

open class AppendToBody: WysiwygBaseAction {
  public static let type: MBTActionType = "AppendToBody"
  private var index: Int32
  private var text: String
  public init(_ index: Int32, _ text: String) {
    self.index = index
    self.text = text
    super.init(AppendToBody.type)
  }

  @discardableResult
  open override func performImpl(_ modelOrApplication: WYSIWIG, _: MBTComponent) -> MBTComponent {
    modelOrApplication.appendText(index, text)
    return ComposeComponent()
  }

  @discardableResult
  open override func tostring() -> String {
    return "AppendToBody(index=\(index), text=\(text))"
  }
}
