// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/backend/archive-message-backend.ts >>>

import Foundation

open class ArchiveMessageBackend: ArchiveMessage {
  private var lastMoveToSpamTime: Int64!
  private var messageListDisplayBackend: MessageListDisplayBackend
  private var clientsHandler: MailboxClientHandler
  public init(_ messageListDisplayBackend: MessageListDisplayBackend, _ clientsHandler: MailboxClientHandler) {
    self.messageListDisplayBackend = messageListDisplayBackend
    self.clientsHandler = clientsHandler
  }

  open func archiveMessage(_ order: Int32) {
    let tid = messageListDisplayBackend.getThreadMessage(order).tid!
    clientsHandler.getCurrentClient().archive("Archive", tid)
    lastMoveToSpamTime = currentTimeMs()
  }

  @discardableResult
  open func toastShown() -> Bool {
    if lastMoveToSpamTime == nil {
      return false
    }
    return currentTimeMs() - lastMoveToSpamTime! < 5000
  }
}
