// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/backend/expandable-threads-backend.ts >>>

import Foundation

open class ExpandableThreadsBackend: ExpandableThreads {
  private var messageListDisplayBackend: MessageListDisplayBackend
  private var clientsHandler: MailboxClientHandler
  public init(_ messageListDisplayBackend: MessageListDisplayBackend, _ clientsHandler: MailboxClientHandler) {
    self.messageListDisplayBackend = messageListDisplayBackend
    self.clientsHandler = clientsHandler
  }

  open func collapseThread(_: Int32) {
    return
  }

  open func expandThread(_: Int32) {
    return
  }

  open func markThreadMessageAsRead(_ threadOrder: Int32, _ messageOrder: Int32) {
    let message = getMessageInThread(threadOrder, messageOrder)
    clientsHandler.getCurrentClient().markMessageAsRead(message.mid)
  }

  open func markThreadMessageAsUnRead(_ threadOrder: Int32, _ messageOrder: Int32) {
    let message = getMessageInThread(threadOrder, messageOrder)
    clientsHandler.getCurrentClient().markMessageAsUnread(message.mid)
  }

  @discardableResult
  private func getMessageInThread(_ threadOrder: Int32, _ messageOrder: Int32) -> MessageMeta {
    let thread = messageListDisplayBackend.getThreadMessage(threadOrder)
    let messages = clientsHandler.getCurrentClient().getMessagesInThread(thread.tid!, messageOrder + 1)
    return messages[messageOrder]
  }
}
