// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/backend/folder-navigator-backend.ts >>>

import Foundation

open class FolderNavigatorBackend: FolderNavigator {
  private var mailListDisplayBackend: MessageListDisplayBackend
  private var clientsHandler: MailboxClientHandler
  public init(_ mailListDisplayBackend: MessageListDisplayBackend, _ clientsHandler: MailboxClientHandler) {
    self.mailListDisplayBackend = mailListDisplayBackend
    self.clientsHandler = clientsHandler
  }

  @discardableResult
  open func getFoldersList() -> YSArray<Folder> {
    return clientsHandler.getCurrentClient().getFolderList().map {
      meta in
      Folder.fromDTO(meta)
    }
  }

  open func goToFolder(_ folderDisplayName: String) {
    let folderBackendName = toBackendFolderName(folderDisplayName)
    let folder = clientsHandler.getCurrentClient().getFolderList().filter {
      f in
      f.name == folderBackendName
    }[0]
    mailListDisplayBackend.setCurrentFolderId(folder.fid)
  }

  @discardableResult
  open func getCurrentFolder() -> Folder {
    let currentFolderName = clientsHandler.getCurrentClient().getFolderList().filter {
      meta in
      meta.fid == self.mailListDisplayBackend.getCurrentFolderId()
    }[0].name!
    return Folder(currentFolderName)
  }
}
