// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/backend/labeled-backend.ts >>>

import Foundation

open class MarkableImportantBackend: MarkableImportant {
  private var mailListDisplayBackend: MessageListDisplayBackend
  private var clientsHandler: MailboxClientHandler
  public init(_ mailListDisplayBackend: MessageListDisplayBackend, _ clientsHandler: MailboxClientHandler) {
    self.mailListDisplayBackend = mailListDisplayBackend
    self.clientsHandler = clientsHandler
  }

  open func markAsImportant(_ order: Int32) {
    let tid = mailListDisplayBackend.getThreadMessage(order).tid!
    let lid = clientsHandler.getCurrentClient().getLabelList().filter {
      label in
      label.type == LabelType.important
    }[0].lid
    clientsHandler.getCurrentClient().markThreadWithLabel(tid, lid)
  }

  open func markAsUnimportant(_ order: Int32) {
    let tid = mailListDisplayBackend.getThreadMessage(order).tid!
    let lid = clientsHandler.getCurrentClient().getLabelList().filter {
      label in
      label.type == LabelType.important
    }[0].lid
    clientsHandler.getCurrentClient().unmarkThreadWithLabel(tid, lid)
  }
}
