// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/backend/markable-backend.ts >>>

import Foundation

open class MarkableBackend: MarkableRead {
  private var mailListDisplayBackend: MessageListDisplayBackend
  private var clientsHandler: MailboxClientHandler
  public init(_ mailListDisplayBackend: MessageListDisplayBackend, _ clientsHandler: MailboxClientHandler) {
    self.mailListDisplayBackend = mailListDisplayBackend
    self.clientsHandler = clientsHandler
  }

  open func markAsRead(_ order: Int32) {
    let message = mailListDisplayBackend.getThreadMessage(order)
    if message.tid != nil {
      clientsHandler.getCurrentClient().markThreadAsRead(message.tid!)
    } else {
      clientsHandler.getCurrentClient().markMessageAsRead(message.mid)
    }
  }

  open func markAsUnread(_ order: Int32) {
    let message = mailListDisplayBackend.getThreadMessage(order)
    if message.tid != nil {
      clientsHandler.getCurrentClient().markThreadAsUnread(message.tid!)
    } else {
      clientsHandler.getCurrentClient().markMessageAsUnread(message.mid)
    }
  }
}
