// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/backend/mobile-mail-backend.ts >>>

import Foundation

open class MobileMailBackend: App {
  public static var allSupportedFeatures: YSArray<FeatureID> = YSArray(ArchiveMessageFeature.get.name, MessageListDisplayFeature.get.name, MarkableReadFeature.get.name, MarkableImportantFeature.get.name, ExpandableThreadsFeature.get.name, WriteMessageFeature.get.name, DeleteMessageFeature.get.name, SpamableFeature.get.name, MovableToFolderFeature.get.name, CreatableFolderFeature.get.name, FolderNavigatorFeature.get.name, YandexLoginFeature.get.name, MultiAccountFeature.get.name)
  public var supportedFeatures: YSArray<FeatureID> = MobileMailBackend.allSupportedFeatures
  public var archive: ArchiveMessageBackend
  public var messageListDisplay: MessageListDisplayBackend
  public var folderNavigator: FolderNavigatorBackend
  public var markable: MarkableBackend
  public var markableImportant: MarkableImportantBackend
  public var writeMessage: WriteMessageBackend
  public var deleteMessage: DeleteMessageBackend
  public var composeMessage: ComposeMessageBackend
  public var spamable: SpamableBackend
  public var movableToFolder: MovableToFolderBackend
  public var creatableFolder: CreatableFolderBackend
  public var expandableThreads: ExpandableThreadsBackend
  public var yandexLogin: YandexLoginBackend
  public var multiAccount: MultiAccountBackend
  private var cache: YSMap<String, Any> = YSMap()
  public let clientsHandler: MailboxClientHandler
  public init(_ clientsHandler: MailboxClientHandler) {
    self.clientsHandler = clientsHandler
    messageListDisplay = MessageListDisplayBackend(clientsHandler)
    folderNavigator = FolderNavigatorBackend(messageListDisplay, clientsHandler)
    markable = MarkableBackend(messageListDisplay, clientsHandler)
    markableImportant = MarkableImportantBackend(messageListDisplay, clientsHandler)
    writeMessage = WriteMessageBackend(messageListDisplay, clientsHandler)
    deleteMessage = DeleteMessageBackend(messageListDisplay, clientsHandler)
    composeMessage = ComposeMessageBackend(clientsHandler)
    spamable = SpamableBackend(messageListDisplay, clientsHandler)
    movableToFolder = MovableToFolderBackend(messageListDisplay, clientsHandler)
    creatableFolder = CreatableFolderBackend(clientsHandler)
    expandableThreads = ExpandableThreadsBackend(messageListDisplay, clientsHandler)
    yandexLogin = YandexLoginBackend(clientsHandler)
    archive = ArchiveMessageBackend(messageListDisplay, clientsHandler)
    multiAccount = MultiAccountBackend(clientsHandler)
  }

  @discardableResult
  open func getFeature(_ feature: FeatureID) -> Any {
    return FeatureRegistry().register(MessageListDisplayFeature.get, messageListDisplay).register(MarkableReadFeature.get, markable).register(MarkableImportantFeature.get, markableImportant).register(ExpandableThreadsFeature.get, expandableThreads).register(WriteMessageFeature.get, writeMessage).register(DeleteMessageFeature.get, deleteMessage).register(ComposeMessageFeature.get, composeMessage).register(SpamableFeature.get, spamable).register(FolderNavigatorFeature.get, folderNavigator).register(MovableToFolderFeature.get, movableToFolder).register(CreatableFolderFeature.get, creatableFolder).register(YandexLoginFeature.get, yandexLogin).register(ArchiveMessageFeature.get, archive).register(MultiAccountFeature.get, multiAccount).get(feature)
  }

  @discardableResult
  open func dump() -> String {
    var s = "\(messageListDisplay.getCurrentFolder().name)\n"
    let threads = messageListDisplay.getMessageDTOList(3)
    for thread in threads {
      let threadSelector = thread.threadCount != nil ? "\(thread.threadCount!)v" : ""
      s += "\(reduced(thread.mid)) \(thread.sender)\t\(thread.unread ? "*" : "o")\t\(thread.subjectText)\t\(threadSelector)\t\(thread.timestamp)\n"
      let threadSize: Int32! = Message.fromMeta(thread).threadCounter
      if threadSize != nil {
        for message in clientsHandler.getCurrentClient().getMessagesInThread(thread.tid!, threadSize) {
          s += "\t\t\(reduced(message.mid)) \(message.sender)\t\(message.unread ? "*" : "o")\t\(message.subjectText)\t\(message.fid)\t\(thread.timestamp)\n"
        }
      }
    }
    return s
  }

  @discardableResult
  private func getCached<T>(_ key: String, _ f: @escaping () -> T) -> T {
    if cache.has(key) {
      return cache.get(key) as! T
    }
    let gotValue = f()
    cache.set(key, castToAny(gotValue))
    return gotValue
  }
}
