// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/backend/spamable-backend.ts >>>

import Foundation

open class SpamableBackend: Spamable {
  private var lastSpamActionTime: Int64!
  private var messageListDisplayBackend: MessageListDisplayBackend
  private var clientsHandler: MailboxClientHandler
  public init(_ messageListDisplayBackend: MessageListDisplayBackend, _ clientsHandler: MailboxClientHandler) {
    self.messageListDisplayBackend = messageListDisplayBackend
    self.clientsHandler = clientsHandler
  }

  open func moveToSpam(_ order: Int32) {
    let fid = messageListDisplayBackend.getCurrentFolderId()
    let tid = messageListDisplayBackend.getThreadMessage(order).tid!
    clientsHandler.getCurrentClient().moveToSpam(fid, tid)
    lastSpamActionTime = currentTimeMs()
  }

  @discardableResult
  open func toastShown() -> Bool {
    if lastSpamActionTime == nil {
      return false
    }
    return currentTimeMs() - lastSpamActionTime! < 5000
  }

  open func moveFromSpam(_ order: Int32) {
    let fid = messageListDisplayBackend.getInbox().fid
    let tid = requireNonNull(messageListDisplayBackend.getThreadMessage(order).tid, "message must have tid!")
    clientsHandler.getCurrentClient().moveThreadToFolder(fid, tid)
    lastSpamActionTime = currentTimeMs()
  }
}
