// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/backend/write-message-backend.ts >>>

import Foundation

open class WriteMessageBackend: WriteMessage {
  private var messageListDisplayBackend: MessageListDisplayBackend
  private var clientsHandler: MailboxClientHandler
  public init(_ messageListDisplayBackend: MessageListDisplayBackend, _ clientsHandler: MailboxClientHandler) {
    self.messageListDisplayBackend = messageListDisplayBackend
    self.clientsHandler = clientsHandler
  }

  open func sendMessage(_ to: String, _ subject: String) {
    sendMessageWithText(to, subject, nil)
  }

  open func replyMessage() {}

  open func openCompose() {}

  @discardableResult
  open func getTo() -> YSSet<String> {
    return YSSet<String>()
  }

  open func createThread(_ to: String, _ subject: String, _ size: Int32, _ texts: YSArray<String>!) {
    let targetTexts = texts == nil ? YSArray() : texts!
    if texts == nil {
      for i in stride(from: 0, to: size, by: 1) {
        targetTexts.push("AUTOCREATED_THREAD_\(i)")
      }
    }
    let fid = messageListDisplayBackend.getFolderByType(FolderType.sent).fid
    let lastMid: Int64! = getTopMessageMid(fid)
    clientsHandler.getCurrentClient().sendMessage(to, subject, targetTexts[0])
    var newMid: Int64! = lastMid
    while newMid == lastMid {
      newMid = getTopMessageMid(fid)
    }
    let references = clientsHandler.getCurrentClient().getMessageReference(requireNonNull(newMid, "Message should appear!"))
    for i in stride(from: 1, to: size, by: 1) {
      clientsHandler.getCurrentClient().sendMessage(to, subject, targetTexts[i], references)
    }
  }

  open func sendPrepared() {}

  private func sendMessageWithText(_ to: String, _ subject: String, _ text: String!) {
    let toEmail: Email! = stringToEmail(to)
    var topMidToUpdate: ID!
    if toEmail != nil, toEmail.login == getCurrentAccountEmail().login {
      topMidToUpdate = getTopMessageMid(messageListDisplayBackend.getInbox().fid)
    }
    let textToSend = text != nil ? text! : "AUTOCREATED_MESSAGE"
    clientsHandler.getCurrentClient().sendMessage(to, subject, textToSend)
    if topMidToUpdate != nil {
      var newMid: MessageId! = topMidToUpdate
      while newMid == topMidToUpdate {
        newMid = getTopMessageMid(messageListDisplayBackend.getInbox().fid)
      }
    }
  }

  @discardableResult
  private func getCurrentAccountEmail() -> Email {
    return clientsHandler.getCurrentClient().getSettings().payload!.accountInformation.emails[0]
  }

  @discardableResult
  private func getTopMessageMid(_ fid: ID) -> MessageId! {
    let messages = clientsHandler.getCurrentClient().getMessagesInFolder(fid, 1)
    if messages.length == 0 {
      return nil
    }
    return messages[0].mid
  }
}
