// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/components/group-operations-component.ts >>>

import Foundation

open class GroupOperationsComponent: MBTComponent {
  public static let type: MBTComponentType = "GroupOperationsComponent"
  open func assertMatches(_: App, _: App) {}

  @discardableResult
  open func tostring() -> String {
    return getComponentType()
  }

  @discardableResult
  open func getComponentType() -> MBTComponentType {
    return GroupOperationsComponent.type
  }
}

open class AllGroupOperationsActions: MBTComponentActions {
  @discardableResult
  open func getActions(_: App) -> YSArray<MBTAction> {
    let actions: YSArray<MBTAction> = YSArray()
    actions.push(MarkAsReadSelectedMessages())
    actions.push(MarkAsUnreadSelectedMessages())
    RotatableAction.addActions(actions)
    return actions
  }
}

open class NotImplementedInClientsActions: MBTComponentActions {
  @discardableResult
  open func getActions(_ model: App) -> YSArray<MBTAction> {
    let actions: YSArray<MBTAction> = YSArray()
    actions.push(DeleteSelectedMessages())
    actions.push(MarkImportantSelectedAction())
    actions.push(MarkUnimportantSelectedAction())
    actions.push(MarkSpamSelectedAction())
    actions.push(MarkNotSpamSelectedAction())
    FolderNavigatorFeature.get.performIfSupported(model) {
      mailboxModel in
      let folders = mailboxModel.getFoldersList()
      for folder in folders {
        actions.push(MoveToFolderSelectedMessagesAction(folder.name))
      }
    }
    let groupMode: GroupMode! = GroupModeFeature.get.castIfSupported(model)
    if groupMode != nil {
      if groupMode.getSelectedMessages().size != nil {
        for i in groupMode.getSelectedMessages().values() {
          actions.push(UnselectMessageAction(i))
        }
      }
    }
    actions.push(UnselectAllMessagesAction())
    return actions
  }
}
