// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/components/message-component.ts >>>

import Foundation

open class MessageComponent: MBTComponent {
  public static let type: String = "MessageComponent"
  @discardableResult
  open func getComponentType() -> String {
    return MessageComponent.type
  }

  open func assertMatches(_ model: App, _ application: App) {
    let messageNavigatorModel: MessageNavigator! = MessageNavigatorFeature.get.castIfSupported(model)
    let messageNavigatorApp: MessageNavigator! = MessageNavigatorFeature.get.castIfSupported(application)
    if messageNavigatorModel != nil, messageNavigatorApp != nil {
      let openedMessageInModel = messageNavigatorModel.getOpenedMessage()
      let openedMessageInApp = messageNavigatorModel.getOpenedMessage()
      if !FullMessage.matches(openedMessageInModel, openedMessageInApp) {
        fatalError("Opened message are different. Expected: \"\(openedMessageInModel)\". Got: \"\(openedMessageInApp)\"")
      }
    }
  }

  @discardableResult
  open func tostring() -> String {
    return getComponentType()
  }
}

open class AllMessageActions: MBTComponentActions {
  @discardableResult
  open func getActions(_: App) -> YSArray<MBTAction> {
    let actions: YSArray<MBTAction> = YSArray()
    actions.push(BackToMaillist())
    return actions
  }
}
