// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/logging/testopithecus-event.ts >>>

import Foundation

open class TestopithecusEvent {
  private let value: YSMap<String, JSONItem>
  public let name: String
  public init(_ name: String, _ builder: ValueMapBuilder) {
    self.name = name
    value = builder.setEventName(name).build()
  }

  @discardableResult
  open func getAttributes() -> YSMap<String, Any> {
    let result = YSMap<String, Any>()
    value.__forEach {
      v, k in
      let val = JSONItemGetValue(v)
      if val != nil {
        result.set(k, val)
      }
    }
    return result
  }

  @discardableResult
  open func getInt64(_ attribute: String) -> Int64! {
    let value: JSONItem! = undefinedToNull(self.value.get(attribute))
    if value == nil {
      return nil
    }
    if value.kind != JSONItemKind.integer {
      return nil
    }
    return (value as! IntegerJSONItem).asInt64()
  }

  @discardableResult
  open func getInt32(_ attribute: String) -> Int32! {
    let value: JSONItem! = undefinedToNull(self.value.get(attribute))
    if value == nil {
      return nil
    }
    if value.kind != JSONItemKind.integer {
      return nil
    }
    return (value as! IntegerJSONItem).asInt32()
  }

  open func reportVia(_ reporter: EventReporter) {
    var aggregator = TestopithecusRegistry.aggregatorProvider().getAggregator()
    if TestopithecusRegistry.aggregatorProvider().updateAggregator(self) {
      TestopithecusEvent.reportIfPresent(reporter, aggregator.finalize())
      aggregator = TestopithecusRegistry.aggregatorProvider().getAggregator()
    }
    TestopithecusEvent.reportIfPresent(reporter, aggregator.accept(self))
  }

  open func report() {
    reportVia(TestopithecusRegistry.eventReporter())
  }

  private class func reportIfPresent(_ reporter: EventReporter, _ event: TestopithecusEvent!) {
    if event != nil {
      reporter.report(LoggingEvent.fromTestopithecusEvent(event))
    }
  }
}

open class LoggingEvent {
  public let name: String
  public let attributes: YSMap<String, Any>
  public init(_ name: String, _ attributes: YSMap<String, Any>) {
    self.name = name
    self.attributes = attributes
  }

  @discardableResult
  open class func fromTestopithecusEvent(_ event: TestopithecusEvent) -> LoggingEvent {
    let attributes = event.getAttributes()
    attributes.set("timestamp", TestopithecusRegistry.timeProvider.getCurrentTimeMs())
    return LoggingEvent(LoggingEvent.getFormattedName(event), attributes)
  }

  @discardableResult
  private class func getFormattedName(_ event: TestopithecusEvent) -> String {
    return "TESTOPITHECUS_EVENT_" + event.name
  }
}
