// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/logging/agregation/aggregator-provider.ts >>>

import Foundation

public protocol AggregatorProvider {
  @discardableResult
  func getAggregator() -> Aggregator
  @discardableResult
  func updateAggregator(_ eventName: TestopithecusEvent) -> Bool
}

open class MapAggregatorProvider: AggregatorProvider {
  private var aggregators: YSMap<String, Aggregator> = YSMap<String, Aggregator>()
  public var currentAggregator: Aggregator!
  public init() {
    aggregators.set(EventNames.MODEL_SYNC_MESSAGE_LIST, MessageListSyncAggregator())
  }

  @discardableResult
  open func getAggregator() -> Aggregator {
    let current: Aggregator! = currentAggregator
    if current == nil {
      return EmptyAggregator()
    } else {
      return current
    }
  }

  @discardableResult
  open func updateAggregator(_ event: TestopithecusEvent) -> Bool {
    let current: Aggregator! = currentAggregator
    if current != nil, current.accepts(event) {
      return false
    } else {
      currentAggregator = undefinedToNull(aggregators.get(event.name))
      return currentAggregator != nil
    }
  }
}

open class EmptyAggregatorProvider: AggregatorProvider {
  @discardableResult
  open func getAggregator() -> Aggregator {
    return EmptyAggregator()
  }

  @discardableResult
  open func updateAggregator(_: TestopithecusEvent) -> Bool {
    return false
  }
}
