// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/logging/agregation/aggragators/message-list-sync-aggregator.ts >>>

import Foundation

open class MessageListSyncAggregator: Aggregator {
  private var sentMessageIds: YSSet<Int64> = YSSet<Int64>()
  @discardableResult
  open func accept(_ event: TestopithecusEvent) -> TestopithecusEvent! {
    if !accepts(event) {
      return nil
    }
    let messages = event.getAttributes().get("messages") as! YSArray<YSMap<String, Any>>
    let messagesDTO: YSArray<MessageDTO> = YSArray()
    for message in messages {
      let messageDTO = MessageDTO.fromMap(message)
      if !sentMessageIds.has(messageDTO.mid) {
        sentMessageIds.add(messageDTO.mid)
        messagesDTO.push(messageDTO)
      }
    }
    return messagesDTO.length == 0 ? nil : Testopithecus.modelSyncEvents.updateMessageList(messagesDTO)
  }

  @discardableResult
  open func accepts(_ event: TestopithecusEvent) -> Bool {
    return event.name == EventNames.MODEL_SYNC_MESSAGE_LIST
  }

  @discardableResult
  open func finalize() -> TestopithecusEvent! {
    return nil
  }
}
