// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/compose-message-model.ts >>>

import Foundation

open class Draft: DraftView {
  public var subject: String! = ""
  public var to: YSSet<String> = YSSet<String>()
  public var wysiwig: WysiwygModel
  public init(_ wysiwig: WysiwygModel) {
    self.wysiwig = wysiwig
  }

  @discardableResult
  open class func matches(_ first: DraftView, _ second: DraftView) -> Bool {
    return first.getWysiwyg().getRichBody() == second.getWysiwyg().getRichBody() && first.subject == second.subject && Draft.isToEquals(first.to, second.to)
  }

  @discardableResult
  open class func isToEquals(_ first: YSSet<String>, _ second: YSSet<String>) -> Bool {
    if first.size != second.size {
      return false
    }
    for a in first.values() {
      if !second.has(a) {
        return false
      }
    }
    return true
  }

  @discardableResult
  open func tostring() -> String {
    let subj = subject != nil ? subject! : ""
    var tos = ""
    for to in to.values() {
      tos += "\(to),"
    }
    return "Compose(to=\(tos), subject=\(subj), body=\(getWysiwyg().getRichBody()))"
  }

  @discardableResult
  open func copy() -> Draft {
    let copy = Draft(wysiwig)
    copy.subject = subject
    copy.to = to
    return copy
  }

  @discardableResult
  open func getWysiwyg() -> WysiwygView {
    return Wysiwyg(wysiwig)
  }
}

open class Wysiwyg: WysiwygView {
  public var wysiwig: WysiwygModel
  public init(_ wysiwig: WysiwygModel) {
    self.wysiwig = wysiwig
  }

  @discardableResult
  open func getStyles(_ i: Int32) -> YSSet<String> {
    return wysiwig.getStyles()[i]
  }

  @discardableResult
  open func getText() -> String {
    return wysiwig.getSymbols().join("")
  }

  @discardableResult
  open func getRichBody() -> String {
    return wysiwig.getBody()
  }
}

open class ComposeMessageModel: ComposeMessage {
  public var composeDraft: Draft!
  private var wysiwyg: WysiwygModel
  private let accountDataHandler: MailAppModelHandler
  public init(_ wysiwyg: WysiwygModel, _ accountDataHandler: MailAppModelHandler) {
    self.wysiwyg = wysiwyg
    self.accountDataHandler = accountDataHandler
  }

  @discardableResult
  open func getDraft() -> DraftView {
    return demandDraft()
  }

  open func goToMessageReply() {
    composeDraft = Draft(wysiwyg)
  }

  open func setBody(_ body: String) {
    let draft = demandDraft()
    clearBody()
    draft.wysiwig.appendText(0, body)
  }

  open func setSubject(_ subject: String) {
    demandDraft().subject = subject
  }

  open func addTo(_ to: String) {
    demandDraft().to.add(to)
  }

  open func addToUsingSuggest(_ to: String) {
    demandDraft().to.add(accountDataHandler.getCurrentAccount().contacts.filter {
      contact in
      contact.startsWith(to)
    }[0])
  }

  open func openCompose() {
    composeDraft = Draft(wysiwyg)
  }

  @discardableResult
  open func getTo() -> YSSet<String> {
    return getDraft().to
  }

  open func clearBody() {
    demandDraft().wysiwig.clear()
  }

  open func clearSubject() {
    demandDraft().subject = nil
  }

  open func removeTo(_ order: Int32) {
    var toToDelete = ""
    var currentToNumber = 0
    for to in setToArray(demandDraft().to) {
      if currentToNumber == order {
        toToDelete = to
        break
      }
      currentToNumber += 1
    }
    demandDraft().to.delete(toToDelete)
  }

  @discardableResult
  private func demandDraft() -> Draft {
    return requireNonNull(composeDraft, "Draft wasn't created!")
  }
}
