// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/group-mode-model.ts >>>

import Foundation

open class GroupModeModel: GroupMode {
  public var selectedOrders: YSSet<Int32> = YSSet<Int32>()
  private var markableModel: MarkableReadModel
  private var deleteMessageModel: DeleteMessageModel
  private var archive: ArchiveMessageModel
  private var important: MarkableImportantModel
  private var spam: SpamableModel
  private var moveToFolder: MovableToFolderModel
  public init(_ markableModel: MarkableReadModel, _ deleteMessageModel: DeleteMessageModel, _ archive: ArchiveMessageModel, _ important: MarkableImportantModel, _ spam: SpamableModel, _ moveToFolder: MovableToFolderModel) {
    self.markableModel = markableModel
    self.deleteMessageModel = deleteMessageModel
    self.archive = archive
    self.important = important
    self.spam = spam
    self.moveToFolder = moveToFolder
  }

  @discardableResult
  open func getSelectedMessages() -> YSSet<Int32> {
    return selectedOrders
  }

  @discardableResult
  open func isInGroupMode() -> Bool {
    return selectedOrders.size != 0
  }

  open func markAsReadSelectedMessages() {
    for order in selectedOrders.values() {
      markableModel.markAsRead(order)
    }
    selectedOrders = YSSet<Int32>()
  }

  open func markAsUnreadSelectedMessages() {
    for order in selectedOrders.values() {
      markableModel.markAsUnread(order)
    }
    selectedOrders = YSSet<Int32>()
  }

  open func deleteSelectedMessages() {
    deleteMessageModel.deleteMessages(selectedOrders)
    selectedOrders = YSSet<Int32>()
  }

  open func selectMessage(_ byOrder: Int32) {
    selectedOrders.add(byOrder)
  }

  open func archiveSelectedMessages() {
    archive.archiveMessages(selectedOrders)
    selectedOrders = YSSet<Int32>()
  }

  open func markAsImportantSelectedMessages() {
    for order in selectedOrders.values() {
      important.markAsImportant(order)
    }
    selectedOrders = YSSet<Int32>()
  }

  open func markAsNotSpamSelectedMessages() {
    spam.moveFromSpamMessages(selectedOrders)
    selectedOrders = YSSet<Int32>()
  }

  open func markAsSpamSelectedMessages() {
    spam.moveToSpamMessages(selectedOrders)
    selectedOrders = YSSet<Int32>()
  }

  open func markAsUnImportantSelectedMessages() {
    for order in selectedOrders.values() {
      important.markAsUnimportant(order)
    }
    selectedOrders = YSSet<Int32>()
  }

  open func moveToFolderSelectedMessages(_ folderName: String) {
    for order in selectedOrders.values() {
      moveToFolder.moveMessageToFolder(order, folderName)
    }
    selectedOrders = YSSet<Int32>()
  }

  open func unselectAllMessages() {
    selectedOrders = YSSet<Int32>()
  }

  open func unselectMessage(_ byOrder: Int32) {
    selectedOrders.delete(byOrder)
  }

  @discardableResult
  open func copy() -> GroupModeModel {
    let copy = GroupModeModel(markableModel, deleteMessageModel, archive, important, spam, moveToFolder)
    copy.selectedOrders = selectedOrders
    return copy
  }

  open func initialMessageSelect(_ byOrder: Int32) {
    selectedOrders = YSSet<Int32>(YSArray(byOrder))
  }
}
