// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/mail-model.ts >>>

import Foundation

public typealias FolderName = String

open class Folder {
  public let name: FolderName
  public init(_ name: FolderName) {
    self.name = name
  }

  @discardableResult
  open class func fromDTO(_ dto: FolderDTO) -> Folder {
    let name: String! = dto.name
    if name == nil {
      fatalError("Folder with fid \(dto.fid) has no folder!")
    }
    return Folder(name)
  }

  @discardableResult
  open func copy() -> Folder {
    return Folder(name)
  }

  @discardableResult
  open func tostring() -> String {
    return "Folder(\(name))"
  }
}

open class DefaultFolderName {
  public static var inbox: FolderName = "Inbox"
  public static var sent: FolderName = "Sent"
  public static var outgoing: FolderName = "Outbox"
  public static var trash: FolderName = "Trash"
  public static var spam: FolderName = "Spam"
  public static var draft: FolderName = "Drafts"
  public static var archive: FolderName = "Archive"
}

@discardableResult
public func toBackendFolderName(_ folderDisplayName: String) -> String {
  switch folderDisplayName {
  case DefaultFolderName.inbox:
    return "Inbox"
  case DefaultFolderName.sent:
    return "Sent"
  case DefaultFolderName.outgoing:
    return "Outbox"
  case DefaultFolderName.trash:
    return "Trash"
  case DefaultFolderName.spam:
    return "Spam"
  case DefaultFolderName.draft:
    return "Drafts"
  case DefaultFolderName.archive:
    return "Archive"
  default:
    return folderDisplayName
  }
}

open class Message: MessageView {
  public var from: String
  public var subject: String
  public var timestamp: Int64
  public var threadCounter: Int32!
  public var read: Bool
  public var important: Bool
  public init(_ from: String, _ subject: String, _ timestamp: Int64, _ threadCounter: Int32! = 1, _ read: Bool = false, _ important: Bool = false) {
    self.from = from
    self.subject = subject
    self.timestamp = timestamp
    self.threadCounter = threadCounter
    self.read = read
    self.important = important
  }

  @discardableResult
  open class func fromMeta(_ meta: MessageMeta) -> Message {
    return Message(meta.sender, meta.subjectText, meta.timestamp, meta.threadCount == nil ? nil : stringToInt32(meta.threadCount), !meta.unread)
  }

  @discardableResult
  open class func matches(_ first: MessageView, _ second: MessageView) -> Bool {
    return first.subject == second.subject && first.read == second.read
  }

  @discardableResult
  open func threadSize() -> Int32 {
    let counter: Int32! = threadCounter
    return counter != nil ? counter : 1
  }

  @discardableResult
  open func tostring() -> String {
    return "MessageView(from=\(from), subject=\(subject), read=\(read), important=\(important))"
  }

  @discardableResult
  open func copy() -> Message {
    return Message(from, subject, timestamp, threadCounter, read, important)
  }
}

open class FullMessage: FullMessageView {
  public let head: MessageView
  public var mutableHead: Message
  public var to: YSSet<String>
  public var body: String
  public init(_ head: Message, _ to: YSSet<String> = YSSet<String>(), _ body: String = "") {
    self.to = to
    self.body = body
    self.head = head
    mutableHead = head
  }

  @discardableResult
  open class func fromMeta(_ meta: MessageMeta) -> FullMessage {
    return FullMessage(Message.fromMeta(meta))
  }

  @discardableResult
  open class func matches(_ first: FullMessageView, _ second: FullMessageView) -> Bool {
    return Message.matches(first.head, second.head) && first.to == second.to && first.body == second.body
  }

  @discardableResult
  open func tostring() -> String {
    return "Message(from=\(head.from),subject=\(head.subject), read=\(head.read), to=\(to)," + "body=\(body))"
  }

  @discardableResult
  open func copy() -> FullMessage {
    return FullMessage(mutableHead.copy(), to, body)
  }
}

public typealias MessageId = ID

public typealias FolderId = ID

open class MailAppModelHandler {
  public var accountsManager: AccountsManager
  public var accountsData: YSArray<AccountMailboxData>
  public init(_ accountsData: YSArray<AccountMailboxData>) {
    self.accountsData = accountsData
    accountsManager = AccountsManager(accountsData.map {
      data in
      data.userAccount
    })
  }

  open func logInToAccount(_ account: UserAccount) {
    accountsManager.logInToAccount(account)
  }

  open func switchToAccount(_ login: String) {
    accountsManager.switchToAccount(login)
  }

  @discardableResult
  open func isLoggedIn() -> Bool {
    return accountsManager.isLoggedIn()
  }

  @discardableResult
  open func getCurrentAccount() -> AccountMailboxData {
    if !hasCurrentAccount() {
      fatalError("Account was requested, but is not set")
    }
    return accountsData[self.accountsManager.currentAccount!]
  }

  @discardableResult
  open func getLoggedInAccounts() -> YSArray<UserAccount> {
    return accountsManager.getLoggedInAccounts()
  }

  @discardableResult
  open func hasCurrentAccount() -> Bool {
    return accountsManager.currentAccount != nil && accountsManager.currentAccount! < accountsData.length
  }

  @discardableResult
  open func copy() -> MailAppModelHandler {
    let accountsDataCopy = accountsData.map {
      acc in
      acc.copy()
    }
    let result = MailAppModelHandler(accountsDataCopy)
    result.accountsManager = accountsManager.copy()
    return result
  }
}

open class AccountSettings {
  public var groupBySubject: Bool
  public init(_ groupBySubject: Bool) {
    self.groupBySubject = groupBySubject
  }
}

open class AccountMailboxData {
  public let userAccount: UserAccount
  public var messages: YSMap<MessageId, FullMessage>
  public var folderToMessages: YSMap<FolderName, YSSet<MessageId>>
  public var threads: YSArray<YSSet<MessageId>>
  public var aliases: YSArray<String>
  public var contacts: YSArray<String>
  public var accountSettings: AccountSettings
  public init(_ userAccount: UserAccount, _ messages: YSMap<MessageId, FullMessage>, _ folderToMessages: YSMap<FolderName, YSSet<MessageId>>, _ threads: YSArray<YSSet<MessageId>>, _ aliases: YSArray<String>, _ contacts: YSArray<String>, _ accountSettings: AccountSettings) {
    self.userAccount = userAccount
    self.messages = messages
    self.folderToMessages = folderToMessages
    self.threads = threads
    self.aliases = aliases
    self.contacts = contacts
    self.accountSettings = accountSettings
  }

  @discardableResult
  open func copy() -> AccountMailboxData {
    let userAccountCopy = UserAccount(userAccount.login, userAccount.password)
    let accountSettingsCopy = AccountSettings(accountSettings.groupBySubject)
    let messagesCopy = YSMap<MessageId, FullMessage>()
    for mid in messages.keys() {
      messagesCopy.set(mid, messages.get(mid)!.copy())
    }
    let threadsCopy: YSArray<YSSet<MessageId>> = YSArray()
    threads.forEach {
      thread in
      let threadCopy = YSSet(thread)
      threadsCopy.push(threadCopy)
    }
    let aliasesCopy = copyArray(aliases)
    let contactsCopy = copyArray(contacts)
    let folderToMessagesCopy: YSMap<FolderName, YSSet<MessageId>> = YSMap<FolderName, YSSet<MessageId>>()
    folderToMessages.__forEach {
      mids, folderName in
      folderToMessagesCopy.set(folderName, YSSet(mids))
    }
    return AccountMailboxData(userAccountCopy, messagesCopy, folderToMessagesCopy, threadsCopy, aliasesCopy, contactsCopy, accountSettingsCopy)
  }
}

open class MailboxModel: AppModel {
  public static var allSupportedFeatures: YSArray<FeatureID> = YSArray(MessageListDisplayFeature.get.name, FolderNavigatorFeature.get.name, MessageNavigatorFeature.get.name, MarkableReadFeature.get.name, MarkableImportantFeature.get.name, GroupModeFeature.get.name, SettingsFeature.get.name, RotatableFeature.get.name, ExpandableThreadsModelFeature.get.name, ExpandableThreadsFeature.get.name, WriteMessageFeature.get.name, DeleteMessageFeature.get.name, ComposeMessageFeature.get.name, SpamableFeature.get.name, MovableToFolderFeature.get.name, CreatableFolderFeature.get.name, WysiwygFeature.get.name, ArchiveMessageFeature.get.name, YandexLoginFeature.get.name, MultiAccountFeature.get.name, ContextMenuFeature.get.name, ShortSwipeDeleteFeature.get.name, GroupBySubjectFeature.get.name, SettingsNavigatorFeature.get.name, AccountSettingsNavigatorFeature.get.name)
  public var supportedFeatures: YSArray<FeatureID> = copyArray(MailboxModel.allSupportedFeatures)
  public let messageListDisplay: MessageListDisplayModel
  public let markableRead: MarkableReadModel
  public let markableImportant: MarkableImportantModel
  public let messageNavigator: MessageNavigatorModel
  public let deletableMessages: DeleteMessageModel
  public let groupMode: GroupModeModel
  public let rotatable: RotatableModel
  public let readOnlyExpandableThreads: ReadOnlyExpandableThreadsModel
  public let expandableThreads: ExpandableThreadsModel
  public let writable: WriteMessageModel
  public let composable: ComposeMessageModel
  public let folderNavigator: FolderNavigatorModel
  public let movableToFolder: MovableToFolderModel
  public let creatableFolder: CreatableFolderModel
  public let wysiwyg: WysiwygModel
  public let login: LoginModel
  public let multiAccount: MultiAccountModel
  public let contextMenu: ContextMenuModel
  public let shortSwipeDelete: ShortSwipeDeleteModel
  public let archiveMessage: ArchiveMessageModel
  public let settingsModel: SettingsModel
  public let spammable: SpamableModel
  public let mailAppModelHandler: MailAppModelHandler
  public init(_ mailAppModelHandler: MailAppModelHandler) {
    self.mailAppModelHandler = mailAppModelHandler
    let accountsSettings: YSArray<AccountSettings> = mailAppModelHandler.accountsData.map {
      account in
      account.accountSettings
    }
    settingsModel = SettingsModel(accountsSettings, self.mailAppModelHandler.accountsManager)
    messageListDisplay = MessageListDisplayModel(mailAppModelHandler, settingsModel)
    folderNavigator = FolderNavigatorModel(messageListDisplay)
    markableRead = MarkableReadModel(messageListDisplay)
    markableImportant = MarkableImportantModel(messageListDisplay)
    messageNavigator = MessageNavigatorModel(markableRead, messageListDisplay)
    deletableMessages = DeleteMessageModel(messageListDisplay)
    rotatable = RotatableModel()
    readOnlyExpandableThreads = ReadOnlyExpandableThreadsModel(messageListDisplay)
    expandableThreads = ExpandableThreadsModel(readOnlyExpandableThreads, messageListDisplay)
    wysiwyg = WysiwygModel()
    composable = ComposeMessageModel(wysiwyg, mailAppModelHandler)
    writable = WriteMessageModel(messageListDisplay, messageNavigator, composable, mailAppModelHandler, wysiwyg)
    movableToFolder = MovableToFolderModel(messageListDisplay)
    creatableFolder = CreatableFolderModel(messageListDisplay)
    contextMenu = ContextMenuModel(deletableMessages, markableImportant, markableRead, movableToFolder)
    shortSwipeDelete = ShortSwipeDeleteModel(deletableMessages)
    login = LoginModel(mailAppModelHandler)
    multiAccount = MultiAccountModel(mailAppModelHandler)
    archiveMessage = ArchiveMessageModel(messageListDisplay)
    spammable = SpamableModel(messageListDisplay, markableRead)
    groupMode = GroupModeModel(markableRead, deletableMessages, archiveMessage, markableImportant, spammable, movableToFolder)
  }

  @discardableResult
  open func getFeature(_ feature: FeatureID) -> Any {
    return FeatureRegistry().register(MessageListDisplayFeature.get, messageListDisplay).register(FolderNavigatorFeature.get, folderNavigator).register(MessageNavigatorFeature.get, messageNavigator).register(MarkableReadFeature.get, markableRead).register(MarkableImportantFeature.get, markableImportant).register(GroupModeFeature.get, groupMode).register(SettingsFeature.get, settingsModel).register(RotatableFeature.get, rotatable).register(ExpandableThreadsModelFeature.get, readOnlyExpandableThreads).register(ExpandableThreadsFeature.get, expandableThreads).register(WriteMessageFeature.get, writable).register(DeleteMessageFeature.get, deletableMessages).register(ComposeMessageFeature.get, composable).register(SpamableFeature.get, spammable).register(MovableToFolderFeature.get, movableToFolder).register(CreatableFolderFeature.get, creatableFolder).register(WysiwygFeature.get, wysiwyg).register(YandexLoginFeature.get, login).register(ContextMenuFeature.get, contextMenu).register(ShortSwipeDeleteFeature.get, shortSwipeDelete).register(ArchiveMessageFeature.get, archiveMessage).register(MultiAccountFeature.get, multiAccount).register(SettingsNavigatorFeature.get, settingsModel).register(GroupBySubjectFeature.get, settingsModel).register(AccountSettingsNavigatorFeature.get, settingsModel).get(feature)
  }

  @discardableResult
  open func copy() -> AppModel {
    let accountDataHandlerCopy = mailAppModelHandler.copy()
    let model: MailboxModel = MailboxModel(accountDataHandlerCopy)
    model.supportedFeatures = supportedFeatures
    model.messageNavigator.openedMessage = messageNavigator.openedMessage
    model.rotatable.landscape = rotatable.landscape
    if groupMode.selectedOrders != nil {
      model.groupMode.selectedOrders = copySet(groupMode.selectedOrders)
    }
    for id in readOnlyExpandableThreads.expanded.values() {
      model.readOnlyExpandableThreads.expanded.add(id)
    }
    if composable.composeDraft != nil {
      model.composable.composeDraft = composable.composeDraft!.copy()
    }
    return model
  }

  @discardableResult
  open func dump() -> String {
    var s = ""
    let threadMids = messageListDisplay.getMessageIdList(10)
    s += "\(messageListDisplay.getCurrentFolder().name)\n"
    for i in stride(from: 0, to: threadMids.length, by: 1) {
      let threadMid = threadMids[i]
      let thread = messageListDisplay.makeMessageThreadView(threadMid)
      let msgHead = thread.mutableHead
      let threadSelector = msgHead.threadCounter != nil ? "\(msgHead.threadCounter!)v" : ""
      s += "\(reduced(threadMid)) \(msgHead.from)\t\(msgHead.read ? "o" : "*")" + "\t\(msgHead.subject)\t\(threadSelector)\t\(msgHead.timestamp)\n"
      if msgHead.threadCounter != nil {
        for mid in messageListDisplay.getMessagesInThreadByMid(threadMid) {
          let message = messageListDisplay.storedMessage(mid)
          s += "\t\t\(reduced(mid)) \(message.head.from)\t\(message.head.read ? "o" : "*")\t\(message.head.subject)" + "\t\(messageListDisplay.storedFolder(mid).name)\t\(msgHead.timestamp)\n"
        }
      }
    }
    return s
  }
}
