// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/message-list-display-model.ts >>>

import Foundation

open class MessageListDisplayModel: MessageListDisplay {
  private var currentFolder: Folder = Folder(DefaultFolderName.inbox)
  public var accountDataHandler: MailAppModelHandler
  private var groupBySubjectModel: GroupBySubject
  public init(_ accountDataHandler: MailAppModelHandler, _ groupBySubjectModel: GroupBySubject) {
    self.accountDataHandler = accountDataHandler
    self.groupBySubjectModel = groupBySubjectModel
  }

  @discardableResult
  open func getCurrentFolder() -> Folder {
    if currentFolder == nil {
      currentFolder = Folder(DefaultFolderName.inbox)
    }
    return currentFolder
  }

  open func setCurrentFolder(_ folder: Folder) {
    currentFolder = folder
  }

  @discardableResult
  open func getMessageList(_ limit: Int32) -> YSArray<MessageView> {
    return getMessageIdList(limit).map {
      mid in
      self.isInThreadMode() ? self.makeMessageThreadView(mid).head : self.storedMessage(mid).head
    }
  }

  @discardableResult
  open func getFolderList() -> YSArray<Folder> {
    let folders = YSMap<String, Folder>()
    accountDataHandler.getCurrentAccount().folderToMessages.__forEach {
      _, folder in
      folders.set(folder, Folder(folder))
    }
    return valuesArray(folders)
  }

  open func refreshMessageList() {
    return
  }

  @discardableResult
  open func unreadCounter() -> Int32 {
    fatalError("Not implemented")
  }

  @discardableResult
  open func getMessageIdList(_ limit: Int32) -> YSArray<MessageId> {
    let folderMessages: YSArray<MessageId> = YSArray()
    accountDataHandler.getCurrentAccount().folderToMessages.__forEach {
      mids, messageFolder in
      if self.getCurrentFolder().name == messageFolder {
        for mid in mids.values() {
          folderMessages.push(mid)
        }
      }
    }
    folderMessages.sort {
      mid1, mid2 in
      let diff = int64ToInt32(self.makeMessageThreadView(mid2).mutableHead.timestamp - self.makeMessageThreadView(mid1).mutableHead.timestamp)
      if diff != 0 {
        return diff
      }
      return int64ToInt32(mid1 - mid2)
    }
    if !isInThreadMode() {
      return folderMessages.slice(0, limit)
    }
    let filteredFolderMessages: YSArray<MessageId> = YSArray()
    let currentAddedThreads = YSSet<Int32>()
    for mid in folderMessages {
      let threadOrder: Int32! = findThread(mid)
      if threadOrder == nil {
        filteredFolderMessages.push(mid)
      } else if !currentAddedThreads.has(threadOrder) {
        filteredFolderMessages.push(mid)
        currentAddedThreads.add(threadOrder)
      }
    }
    return filteredFolderMessages.slice(0, limit)
  }

  @discardableResult
  open func makeMessageThreadView(_ threadMid: MessageId) -> FullMessage {
    let threadView = storedMessage(threadMid).copy()
    threadView.mutableHead.read = getMessagesInThreadByMid(threadMid).filter {
      mid in
      !self.storedMessage(mid).head.read
    }.length == 0
    return threadView
  }

  @discardableResult
  open func getMessageId(_ order: Int32) -> MessageId {
    let messageIds = getMessageIdList(order + 1)
    if order >= messageIds.length {
      fatalError("No message with order \(order)")
    }
    return messageIds[order]
  }

  @discardableResult
  open func isInThreadMode() -> Bool {
    let notThreadableFolders: YSArray<String> = YSArray(DefaultFolderName.outgoing, DefaultFolderName.draft, DefaultFolderName.trash, DefaultFolderName.spam, DefaultFolderName.archive)
    if notThreadableFolders.includes(getCurrentFolder().name) {
      return false
    }
    return accountDataHandler.getCurrentAccount().accountSettings.groupBySubject
  }

  open func toggleThreadMode() {
    groupBySubjectModel.toggleThreadingSetting()
  }

  open func removeMessage(_ id: MessageId) {
    if !accountDataHandler.getCurrentAccount().messages.has(id) {
      fatalError("No messages with target id")
    }
    let isInTrash = demandFolderMessages(DefaultFolderName.trash).has(id)
    if isInTrash {
      accountDataHandler.getCurrentAccount().folderToMessages.__forEach {
        msgIds, _ in
        msgIds.delete(id)
      }
      accountDataHandler.getCurrentAccount().messages.delete(id)
      for index in stride(from: 0, to: accountDataHandler.getCurrentAccount().threads.length, by: 1) {
        accountDataHandler.getCurrentAccount().threads[index].delete(id)
      }
      accountDataHandler.getCurrentAccount().threads = accountDataHandler.getCurrentAccount().threads.filter({
        thread in
        thread.size != 0
      })
    } else {
      moveMessageToFolder(id, DefaultFolderName.trash)
    }
  }

  @discardableResult
  open func findThread(_ mid: MessageId) -> Int32! {
    for i in stride(from: 0, to: accountDataHandler.getCurrentAccount().threads.length, by: 1) {
      if accountDataHandler.getCurrentAccount().threads[i].has(mid) {
        return i
      }
    }
    return nil
  }

  @discardableResult
  open func storedMessage(_ mid: MessageId) -> FullMessage {
    let message: FullMessage! = undefinedToNull(accountDataHandler.getCurrentAccount().messages.get(mid))
    if message == nil {
      fatalError("No message with mid \(mid) in model!")
    }
    return message!
  }

  @discardableResult
  open func getMessageThreadByOrder(_ order: Int32) -> YSArray<MessageId> {
    let firstMsgMid = getMessageId(order)
    return getMessagesInThreadByMid(firstMsgMid)
  }

  @discardableResult
  open func getMessagesInThreadByMid(_ mid: MessageId) -> YSArray<MessageId> {
    let orderInThreads: Int32! = findThread(mid)
    if orderInThreads == nil {
      return YSArray(mid)
    }
    let threadMids = accountDataHandler.getCurrentAccount().threads[orderInThreads]
    let sortedMids = setToArray(threadMids)
    sortedMids.sort {
      m1, m2 in
      int64ToInt32(self.storedMessage(m2).mutableHead.timestamp - self.storedMessage(m1).mutableHead.timestamp)
    }
    return sortedMids
  }

  @discardableResult
  open func storedFolder(_ mid: MessageId) -> Folder {
    var folderName: FolderName!
    accountDataHandler.getCurrentAccount().folderToMessages.__forEach {
      msgIds, folder in
      for msgId in msgIds.values() {
        if msgId == mid {
          folderName = folder
        }
      }
    }
    if folderName == nil {
      fatalError("No folder for message with mid \(mid) in model!")
    }
    return Folder(folderName!)
  }

  open func moveMessageToFolder(_ mid: MessageId, _ folderName: FolderName) {
    accountDataHandler.getCurrentAccount().folderToMessages.__forEach {
      msgIds, _ in
      msgIds.delete(mid)
    }
    demandFolderMessages(folderName).add(mid)
  }

  open func goToAccountSwitcher() {}

  @discardableResult
  open func getMidsByOrders(_ orders: YSSet<Int32>) -> YSArray<MessageId> {
    let mids: YSArray<MessageId> = YSArray()
    for order in orders.values() {
      for mid in getMessageThreadByOrder(order) {
        mids.push(mid)
      }
    }
    return mids
  }

  @discardableResult
  private func demandFolderMessages(_ folderName: FolderName) -> YSSet<MessageId> {
    let messages: YSSet<Int64>! = undefinedToNull(accountDataHandler.getCurrentAccount().folderToMessages.get(folderName))
    if messages == nil {
      fatalError("Модель не знает про папку '\(folderName)'! Сначала ее надо создать.")
    }
    return messages!
  }
}
