// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM mail/model/message-navigator-model.ts >>>

import Foundation

open class MessageNavigatorModel: MessageNavigator {
  public var openedMessage: MessageId = int64(-1)
  private var markable: MarkableRead
  private var messageListDisplay: MessageListDisplayModel
  public init(_ markable: MarkableRead, _ messageListDisplay: MessageListDisplayModel) {
    self.markable = markable
    self.messageListDisplay = messageListDisplay
  }

  open func closeMessage() {
    openedMessage = int64(-1)
  }

  open func deleteCurrentMessage() {
    let openedMessage = self.openedMessage
    if openedMessage == int64(-1) {
      fatalError("No opened message!")
    }
    closeMessage()
    messageListDisplay.removeMessage(openedMessage)
  }

  open func openMessage(_ order: Int32) {
    markable.markAsRead(order)
    openedMessage = messageListDisplay.getMessageId(order)
  }

  @discardableResult
  open func getOpenedMessage() -> FullMessageView {
    return messageListDisplay.storedMessage(openedMessage)
  }
}
